// Define the BlockData class

// I borrowed a lot of code from XviD's sources here, so I thank all the developpers
// of this wonderful codec

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#ifndef __FAKEBLOCKDATA__
#define __FAKEBLOCKDATA__

#include "MVInterface.h"

class FakeBlockData {
	int x;
	int y;
	VECTOR vector;
	int nSad;
	int nLength;
   int nVariance;
   int nLuma;
   int nRefLuma;
   int nPitch;

   const unsigned char *pRef;

	inline static int SquareLength(const VECTOR& v)
	{ return v.x * v.x + v.y * v.y; }

public : 
	FakeBlockData(int _x, int _y);
	~FakeBlockData();

	void Update(const int *array, const unsigned char *ref, int pitch);

	inline int GetX() const { return x; }
	inline int GetY() const { return y; }
	inline VECTOR GetMV() const { return vector; }
	inline int GetSAD() const { return nSad; }
	inline int GetMVLength() const { return nLength; }
   inline int GetVariance() const { return nVariance; }
   inline int GetLuma() const { return nLuma; }
   inline int GetRefLuma() const { return nRefLuma; }
   inline const unsigned char *GetRef() const { return pRef; }
   inline int GetPitch() const { return nPitch; }
};

#endif