#include "MVInterface.h"

void FakeGroupOfPlanes::Create(int nWidth, int nHeight, int nBlkSize, int nLevelCount, int nPel, int nOverlap, int _yRatioUV)
{
   nLvCount_ = nLevelCount;
//   nOverlap = 2;//_nOverlap;
   int nBlkX1 = (nWidth - nOverlap) / (nBlkSize - nOverlap);
//   if ((nWidth - nOverlap) > (nBlkSize - nOverlap)*nBlkX ) 
//	   nBlkX1++;
   int nBlkY1 = (nHeight - nOverlap)/ (nBlkSize - nOverlap);
//   if ((nHeight - nOverlap) > (nBlkSize - nOverlap)*nBlkY ) 
//	   nBlkY1++;
   nWidth_B = (nBlkSize - nOverlap)*nBlkX1 + nOverlap;
   nHeight_B = (nBlkSize - nOverlap)*nBlkY1 + nOverlap;
   yRatioUV_B = _yRatioUV;

//   nWidth_ = nWidth;
//   nHeight_ = nHeight;

   planes = new FakePlaneOfBlocks*[nLevelCount];
   planes[0] = new FakePlaneOfBlocks(nWidth_B, nHeight_B, nBlkSize, 0, nPel, nOverlap);
	for (int i = 1; i < nLevelCount; i++ )
		planes[i] = new FakePlaneOfBlocks(nWidth_B >> i, nHeight_B >> i, nBlkSize, i, 1, nOverlap);
}

FakeGroupOfPlanes::FakeGroupOfPlanes()
{
   planes = 0;
}

FakeGroupOfPlanes::~FakeGroupOfPlanes()
{
   if ( planes )
   {
      for ( int i = 0; i < nLvCount_; i++ )
		   delete planes[i];
	   delete[] planes;
	   planes = 0; //v1.2.1
   }
}

void FakeGroupOfPlanes::Update(const int *array)
{
   const int *pA = array;
	validity = GetValidity(array);

   pA += 2;
	for ( int i = nLvCount_ - 1; i >= 0; i-- )
		pA += pA[0];

   pA++;

   compensatedPlane = reinterpret_cast<const unsigned char *>(pA);
   compensatedPlaneU = compensatedPlane + nWidth_B * nHeight_B;
   compensatedPlaneV = compensatedPlaneU + nWidth_B * nHeight_B /(2*yRatioUV_B);

   pA = array;
   pA += 2;
	for ( int i = nLvCount_ - 1; i >= 0; i-- )
	{
      planes[i]->Update(pA + 1, compensatedPlane, nWidth_B);
		pA += pA[0];
	}
}

bool FakeGroupOfPlanes::IsSceneChange(int nThSCD1, int nThSCD2) const
{
	return planes[0]->IsSceneChange(nThSCD1, nThSCD2);
}
