// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#ifndef __FGOPLANES__
#define __FGOPLANES__

#include "FakePlaneOfBlocks.h"

class FakeGroupOfPlanes {
	int nLvCount;
	bool validity;
   int nWidth;
   int nHeight;
	FakePlaneOfBlocks **planes;
   const unsigned char *compensatedPlane;
   const unsigned char *compensatedPlaneU;
   const unsigned char *compensatedPlaneV;

public :
	FakeGroupOfPlanes(int w, int h, int size, int lv, int pel);
	~FakeGroupOfPlanes();

	void Update(const int *array);
	bool IsSceneChange(int nThSCD1, int nThSCD2) const;

	inline const FakePlaneOfBlocks& operator[](const int i) const {
		return *(planes[i]);
	}

	inline static bool GetValidity(const int *array) { return (array[1] == 1); }
	inline bool GetValidity() const { return validity; }
   inline const unsigned char *GetCompensatedPlane() const { return compensatedPlane; }
   inline const unsigned char *GetCompensatedPlaneU() const { return compensatedPlaneU; }
   inline const unsigned char *GetCompensatedPlaneV() const { return compensatedPlaneV; }
   inline int GetPitch() const { return nWidth; }
   inline int GetPitchUV() const { return nWidth / 2; }
   inline int GetWidth() const { return nWidth; }
   inline int GetHeight() const { return nHeight; }

	inline const FakePlaneOfBlocks& GetPlane(int i) const { return *(planes[i]); }
};

#endif