#include "MVInterface.h"
#include "commonfunctions.h"

FakePlaneOfBlocks::FakePlaneOfBlocks(int w, int h, int size, int lv, int pel, int _nOverlap)
{
	nWidth_Bi = w;
	nHeight_Bi = h;
   nBlkSize = size;
   nOverlap = _nOverlap;
   nBlkX = (nWidth_Bi - nOverlap) / (nBlkSize - nOverlap); // without remainder
   nBlkY = (nHeight_Bi - nOverlap) / (nBlkSize - nOverlap); //
   nBlkCount = nBlkX * nBlkY;
   nPel = pel;

	nLogPel = ilog2(nPel);
	nLogScale = lv;
	nScale = iexp2(nLogScale);
	
	blocks = new FakeBlockData*[nBlkCount];
	for ( int j = 0, blkIdx = 0; j < nBlkY; j++ )
		for ( int i = 0; i < nBlkX; i++, blkIdx++ )
			blocks[blkIdx] = new FakeBlockData(i * (nBlkSize - nOverlap), j * (nBlkSize - nOverlap));
}

FakePlaneOfBlocks::~FakePlaneOfBlocks()
{
	for ( int i = 0; i < nBlkCount; i++ )
		delete blocks[i];

	delete[] blocks;
}

void FakePlaneOfBlocks::Update(const int *array, const unsigned char *pRef, int nPitch)
{
	array += 0;
	for ( int i = 0; i < nBlkCount; i++ )
	{
		blocks[i]->Update(array, pRef, nPitch);
		array += 6;
	}
}

bool FakePlaneOfBlocks::IsSceneChange(int nTh1, int nTh2) const
{
	int sum = 0;
	for ( int i = 0; i < nBlkCount; i++ )
		sum += ( blocks[i]->GetSAD() > nTh1 ) ? 1 : 0;

	return ( sum > nTh2 );
}