// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#ifndef __FPOBLOCKS__
#define __FPOBLOCKS__

#include "MVInterface.h"
#include "FakeBlockData.h"

class FakePlaneOfBlocks {
    
	int nWidth;
	int nHeight;
	int nBlkX;
	int nBlkY;
	int nBlkSize;
	int nBlkCount;
	int nPel;
	int nLogPel;
	int nScale;
	int nLogScale;

	FakeBlockData **blocks;

public :

	FakePlaneOfBlocks(int w, int h, int size, int lv, int pel);
	~FakePlaneOfBlocks();

	void Update(const int *array, const unsigned char *pRef, int nPitch);
	bool IsSceneChange(int nTh1, int nTh2) const;

	inline bool IsInFrame(int i) const
	{
		return (( i >= 0 ) && ( i < nBlkCount ));
	}
	
	inline const FakeBlockData& operator[](const int i) const {
		return *(blocks[i]);
	}

	inline int GetBlockCount() const { return nBlkCount; }
	inline int GetReducedWidth() const { return nBlkX; }
	inline int GetReducedHeight() const { return nBlkY; }
	inline int GetWidth() const { return nWidth; }
	inline int GetHeight() const { return nHeight; }
	inline int GetScaleLevel() const { return nLogScale; }
	inline int GetEffectiveScale() const { return nScale; }
	inline int GetBlockSize() const { return nBlkSize; }
	inline int GetPel() const { return nPel; }
   inline const FakeBlockData& GetBlock(int i) const { return *(blocks[i]); }
};

#endif
