// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#include "GroupOfPlanes.h"

GroupOfPlanes::GroupOfPlanes(int nWidth, int nHeight, int _nBlkSize, int _nLevelCount, int _nPel, int _nFlags, int _nOverlap, int _nBlkX, int _nBlkY, int _yRatioUV)
{
   nBlkSize = _nBlkSize;
   nLevelCount = _nLevelCount;
   nPel = _nPel;
   nFlags = _nFlags;
   nOverlap = _nOverlap;
   yRatioUV = _yRatioUV;

   planes = new PlaneOfBlocks*[nLevelCount];

   int nBlkX = _nBlkX;
   int nBlkY = _nBlkY;

   planes[0] = new PlaneOfBlocks(nBlkX, nBlkY, nBlkSize, nPel, 0, nFlags, nOverlap, yRatioUV);
   nBlkX /= 2;
   nBlkY /= 2;

   for ( int i = 1; i < nLevelCount - 1; i++ )
   {
      planes[i] = new PlaneOfBlocks(nBlkX, nBlkY, nBlkSize, 1, i, nFlags, nOverlap, yRatioUV);
      nBlkX /= 2;
      nBlkY /= 2;
   }
   planes[nLevelCount-1] = new PlaneOfBlocks(nBlkX, nBlkY, nBlkSize, 1, nLevelCount - 1, nFlags | MOTION_SMALLEST_PLANE, nOverlap, yRatioUV);
}

GroupOfPlanes::~GroupOfPlanes()
{
	for ( int i = 0; i < nLevelCount; i++ )
		delete planes[i];
	delete[] planes;
}

void GroupOfPlanes::SearchMVs(MVGroupOfFrames *pSrcGOF, MVGroupOfFrames *pRefGOF,
                              SearchType searchType, int nSearchParam, int nLambda,
                              int lsad, int pnew, int plevel, bool global, int flags, int *out)
{
	int i;

   nFlags |= flags;

   // write group's size 
   out[0] = GetArraySize();

   // write validity : 1 in that case
   out[1] = 1;

   out += 2;

   VECTOR globalMV = zeroMV; // create and init global motion vector as zero

	// Search the motion vectors, for the low details interpolations first
	// Refining the search until we reach the highest detail interpolation.
   planes[nLevelCount - 1]->SearchMVs(pSrcGOF->GetFrame(nLevelCount-1), 
                                      pRefGOF->GetFrame(nLevelCount-1),
                                      searchType, nSearchParam, nLambda, lsad, pnew, plevel, flags, out, &globalMV);

   out += planes[nLevelCount - 1]->GetArraySize();

	for ( i = nLevelCount - 2; i >= 0; i-- )
	{
		if (global)
		{
		   planes[i+1]->EstimateGlobalMVDoubled(&globalMV); // get updated global MV (doubled)
		}
		planes[i]->InterpolatePrediction(*(planes[i+1]));
		planes[i]->SearchMVs(pSrcGOF->GetFrame(i), pRefGOF->GetFrame(i),
                           searchType, nSearchParam, nLambda, lsad, pnew, plevel, flags, out, &globalMV);
      out += planes[i]->GetArraySize();
	}
}

void GroupOfPlanes::WriteDefaultToArray(int *array)
{
   // write group's size
   array[0] = GetArraySize();

   // write validity : unvalid in that case
   array[1] = 0;

   array += 2;

   // write planes
	for (int i = nLevelCount - 1; i >= 0; i-- )
	{
  		array += planes[i]->WriteDefaultToArray(array);
//      array += planes[i]->GetArraySize();
	}
}

int GroupOfPlanes::GetArraySize()
{
	int size = 2; // size, validity
	for ( int i = 0; i < nLevelCount; i++ )
		size += planes[i]->GetArraySize();

	return size;
}