// Set of tools based on Motion Compensation

// See legal notice in Copying.txt for more information

// Avisynth: www.avisynth.org

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#define WIN32_LEAN_AND_MEAN

#include "AviSynth.h"
#include "MVInterface.h"

// Use MVClip / MVFilter helpers
#include "MVMask.h"
#include "MVDenoise2.h"
#include "MVShow.h"
//#include "MVSpeed.h"
#include "MVCompensate.h"
#include "MVSCDetection.h"
#include "MVIncrease.h"

#include "MVDepan.h" // added by Fizick
//#include "MVInter.h"// added by Fizick
#include "MVFlow.h"// added by Fizick
#include "MVFlowInter.h"// added by Fizick
#include "MVFlowFps.h"// added by Fizick
#include "MVFlowBlur.h"// added by Fizick
#include "MVFlowFps2.h"// added by Fizick

// Work in progress
//#include "MVBidouille.h"

// Special filter, not a good example
#include "MVChangeCompensate.h"

// Analysing filter
#include "MVAnalyse.h"

// Test & helpers filters
//#include "TestFilter.h"
#include "Padding.h"
//#include "QDeQuant.h"
//#include "Deblock.h"
//#include "YUVSource.h"
//#include "Corrector.h"

MVCore mvCore;



/*
AVSValue __cdecl Create_Padding(AVSValue args, void* user_data, IScriptEnvironment* env)
{
	return new Padding(
      args[0].AsClip(),
      args[1].AsInt(8),
		args[2].AsInt(8),
		env);
}
*/
AVSValue __cdecl Create_MVChangeCompensate(AVSValue args, void* user_data, IScriptEnvironment* env)
{
	return new MVChangeCompensate(
		args[0].AsClip(),
		args[1].AsClip(),
		args[2].AsBool(true), //sse
		env);
}
/*
AVSValue __cdecl Create_QDenoise(AVSValue args, void* user_data, IScriptEnvironment* env)
{
	return new QDeQuant(
		args[0].AsClip(),
		args[1].AsInt(25),
      args[2].AsInt(0),
      args[3].AsInt(6),
		args[4].AsBool(true),
      args[5].AsBool(true),
		env);
}

AVSValue __cdecl Create_Deblock(AVSValue args, void* user_data, IScriptEnvironment* env)
{
	return new Deblock(
		args[0].AsClip(),
      args[1].AsInt(25),
      args[2].AsInt(0),
      args[3].AsInt(0),
		args[4].AsBool(true),
      args[5].AsBool(true),
    	env);
}
*/
AVSValue __cdecl Create_MVDenoise2(AVSValue args, void* user_data, IScriptEnvironment* env)
{
   int thT = 10;
	int sadT = 200;
	int thMV = 30;

   int nMode = 0;
   nMode |= args[2].AsBool(true) ? YPLANE : 0;
   nMode |= args[3].AsBool(true) ? UPLANE : 0;
   nMode |= args[4].AsBool(true) ? VPLANE : 0;

	return new MVDenoise2(
		args[0].AsClip(),
      args[1],
      nMode,
      args[5].AsInt(thT),
		args[6].AsInt(sadT),
		args[7].AsInt(thMV),
      args[8].AsInt(MV_DEFAULT_SCD1),
      args[9].AsInt(MV_DEFAULT_SCD2),
      args[10].AsBool(true),
      args[11].AsBool(true),
		env);
}
/*
AVSValue __cdecl Create_Corrector(AVSValue args, void* user_data, IScriptEnvironment* env)
{
	return new Corrector(
		args[0].AsClip(),
      args[1],
      args[2].AsInt(0),
      args[3].AsInt(10),
		env);
}
*/
AVSValue __cdecl Create_MVShow(AVSValue args, void* user_data, IScriptEnvironment* env)
{
	int sc = 1;
	int sil = 0;
	int tol = 20000;
	return new MVShow(
		args[0].AsClip(),
		args[1].AsClip(),
		args[2].AsInt(sc),
		args[3].AsInt(sil),
		args[4].AsInt(tol),
		args[5].AsBool(false),
      args[6].AsInt(MV_DEFAULT_SCD1),
      args[7].AsInt(MV_DEFAULT_SCD2),
      args[8].AsBool(true),
      args[9].AsBool(true),
		env);
}
/*
AVSValue __cdecl Create_MVSpeed(AVSValue args, void* user_data, IScriptEnvironment* env)
{
	return new MVSpeed(
		args[0].AsClip(),
		args[1].AsClip(),
      args[2].AsBool(true),
      args[3].AsBool(true),
      args[4].AsBool(true),
      args[5].AsBool(true),
      args[6].AsBool(true),
      args[7].AsBool(true),
      args[8].AsInt(MV_DEFAULT_SCD1),
      args[9].AsInt(MV_DEFAULT_SCD2),
      args[10].AsBool(true),
      args[11].AsBool(true),
		env);
}
*/
AVSValue __cdecl Create_MVCompensate(AVSValue args, void* user_data, IScriptEnvironment* env)
{
   bool inClip = false;
   bool inLoop = false;
   if ( args[3].AsInt(0) == 2 ) inLoop = true;
   else if ( args[3].AsInt(0) == 1 ) inClip = true;
	return new MVCompensate(
		args[0].AsClip(),
		args[1].AsClip(),
      args[2].AsBool(true), 
      inClip,
      inLoop,
      args[4].AsInt(mvCore.GetNextIdx()),
      args[5].AsInt(MV_DEFAULT_SCD1),
      args[6].AsInt(MV_DEFAULT_SCD2),
      args[7].AsBool(true),
      args[8].AsBool(true),
		env);
}

AVSValue __cdecl Create_MVIncrease(AVSValue args, void* user_data, IScriptEnvironment* env)
{
	return new MVIncrease(
		args[0].AsClip(),
		args[1].AsClip(),
      args[2].AsInt(2),                   // vertical
      args[3].AsInt(1),                   // horizontal
      args[4].AsBool(true),               // sc detection
      args[5].AsInt(mvCore.GetNextIdx()), // frame idx
      args[6].AsInt(MV_DEFAULT_SCD1),
      args[7].AsInt(MV_DEFAULT_SCD2),
      args[8].AsBool(true),
      args[9].AsBool(true),
		env);
}


AVSValue __cdecl Create_MVSCDetection(AVSValue args, void* user_data, IScriptEnvironment* env)
{
	return new MVSCDetection(
		args[0].AsClip(),
		args[1].AsClip(),
      args[2].AsInt(255),
      args[3].AsInt(MV_DEFAULT_SCD1),
      args[4].AsInt(MV_DEFAULT_SCD2),
      args[5].AsBool(true),
      args[6].AsBool(true),
		env);
}

AVSValue __cdecl Create_MVAnalyse(AVSValue args, void* user_data, IScriptEnvironment* env)
{
	int blksize = 	args[1].AsInt(8);             // block size

	int lambda;
	int lsad;
	int pnew;
	int plevel;
	bool global;

	bool truemotion = args[13].AsBool(false); // preset added in v0.9.13 
	if (truemotion)
	{
		lambda = args[7].AsInt(1000*blksize*blksize/64);
		lsad = args[14].AsInt(MV_DEFAULT_SCD1*4*blksize*blksize/64);
		pnew = args[15].AsInt(MV_DEFAULT_SCD1/4*blksize*blksize/64);
		plevel = args[16].AsInt(1);
		global = args[17].AsBool(true);
	}
	else // old versions 0.9.9.1 compatibility mode
	{
		lambda = args[7].AsInt(0);
		lsad = args[14].AsInt(MV_DEFAULT_SCD1*4/3*blksize*blksize/64);
		pnew = args[15].AsInt(0);
		plevel = args[16].AsInt(0);
		global = args[17].AsBool(false);
	}

   return new MVAnalyse(
		args[0].AsClip(),
		blksize,
		args[2].AsInt(1),             // pel
		args[3].AsInt(0),             // levels skip
		args[4].AsInt(LOGARITHMIC),   // search type
		args[5].AsInt(2),             // search parameter
		args[6].AsBool(false),        // is backward
		lambda,             // lambda
      args[8].AsBool(true),        // chroma = true since v1.0.1
		args[9].AsInt(1),             // delta frame
		args[10].AsBool(true),        // mmx
		args[11].AsBool(true),        // isse
      args[12].AsInt(mvCore.GetNextIdx()),   // index of the frames for this analysis
		lsad,          // lsad - SAD limit for lambda using - added by Fizick (was internal fixed to 400 since v0.9.7)
		pnew,          // pnew - cost penalty for new candidate vector - added by Fizick
		plevel,        // plevel - exponent for lambda scaling on level size  - added by Fizick
		global,  // use global motion predictor - added by Fizick
		args[18].AsInt(0), // overlap
		env);
}

//AVSValue __cdecl Create_MVBidouille(AVSValue args, void* user_data, IScriptEnvironment* env)
//{
//	return new MVBidouille(
//		args[0].AsClip(),
//		args[1].AsClip(),
//      args[2].AsClip(),
//      args[3].AsInt(mvCore.GetNextIdx()),
//      args[4].AsInt(0),
//      args[5].AsInt(MV_DEFAULT_SCD1),
//      args[6].AsInt(MV_DEFAULT_SCD2),
//      args[7].AsBool(true),
//      args[8].AsBool(true),
//		env);
//}

AVSValue __cdecl Create_MVMask(AVSValue args, void* user_data, IScriptEnvironment* env)
{
	double ml = args[2].AsFloat(100);
	if (ml<=0)
	   env->ThrowError("MVMask: ML must be > 0.0");
	double gamma = 1;
   int Ysc = 0;
	return new MVMask(
		args[0].AsClip(),
		args[1].AsClip(),
		ml,
		args[3].AsFloat(gamma),
		args[4].AsInt(0), // kind - replaced by Fizick
      args[5].AsInt(Ysc),
      args[6].AsInt(MV_DEFAULT_SCD1),
      args[7].AsInt(MV_DEFAULT_SCD2),
      args[8].AsBool(true),
      args[9].AsBool(true),
		env);
}
/*
AVSValue __cdecl Create_TestFilter(AVSValue args, void* user_data, IScriptEnvironment* env)
{
	return new TestFilter(
		args[0].AsClip(),
		env);
}

AVSValue __cdecl Create_YUVSource(AVSValue args, void *user_data, IScriptEnvironment *env)
{
   return new YUVSource(
      args[0].AsString(""),
      args[1].AsInt(720),
      args[2].AsInt(576),
      env);
}
*/
AVSValue __cdecl Create_MVDepan(AVSValue args, void* user_data, IScriptEnvironment* env) // Added by Fizick
{
	return new MVDepan(
		args[0].AsClip(),
		args[1].AsClip(),
		args[2].AsBool(true), // zoom
		args[3].AsBool(true), // rot
		(float)args[4].AsFloat(1), // pixaspect
		(float)args[5].AsFloat(15), // error
		args[6].AsBool(false), // info
		args[7].AsString(""), // log
      args[8].AsInt(MV_DEFAULT_SCD1),
      args[9].AsInt(MV_DEFAULT_SCD2),
      args[10].AsBool(true),
      args[11].AsBool(true),
		env);
}
/*
AVSValue __cdecl Create_MVInter(AVSValue args, void* user_data, IScriptEnvironment* env)
{
	int time256 = int(args[3].AsFloat(50.0)*256.0/100.0);
	return new MVInter(
		args[0].AsClip(),
		args[1].AsClip(),
		args[2].AsClip(),
      time256, 
      args[4].AsInt(0), // mode
      args[5].AsInt(0), // thres
      args[6].AsInt(mvCore.GetNextIdx()),
      args[7].AsInt(MV_DEFAULT_SCD1),
      args[8].AsInt(MV_DEFAULT_SCD2),
      args[9].AsBool(true),
      args[10].AsBool(true),
		env);
}
*/

AVSValue __cdecl Create_MVFlow(AVSValue args, void* user_data, IScriptEnvironment* env)
{
   double time = args[2].AsFloat(100.0);
	if (time<0 || time>100)
	   env->ThrowError("MVFlow: Time must be from 0 to 100 percent.");
	int time256 = int(time*256.0/100.0);
	return new MVFlow(
		args[0].AsClip(),
		args[1].AsClip(),
      time256, 
      args[3].AsInt(0), // fetch or shift
      args[4].AsInt(mvCore.GetNextIdx()),
      args[5].AsInt(MV_DEFAULT_SCD1),
      args[6].AsInt(MV_DEFAULT_SCD2),
      args[7].AsBool(true),
      args[8].AsBool(true),
		env);
}

AVSValue __cdecl Create_MVFlowInter(AVSValue args, void* user_data, IScriptEnvironment* env)
{
   double time = args[3].AsFloat(50.0);
	if (time<0 || time>100)
	   env->ThrowError("MVFlowInter: Time must be from 0 to 100 percent.");
	int time256 = int(time*256.0/100.0);
	double ml = args[4].AsFloat(100);
	if (ml<=0)
	   env->ThrowError("MVFlowInter: ML must be > 0.0");
	return new MVFlowInter(
		args[0].AsClip(),
		args[1].AsClip(),
		args[2].AsClip(),
      time256, 
      ml, // ml
      args[5].AsInt(mvCore.GetNextIdx()),
      args[6].AsInt(MV_DEFAULT_SCD1),
      args[7].AsInt(MV_DEFAULT_SCD2),
      args[8].AsBool(true),
      args[9].AsBool(true),
		env);
}

AVSValue __cdecl Create_MVFlowFps(AVSValue args, void* user_data, IScriptEnvironment* env)
{
	double ml = args[5].AsFloat(100);
	if (ml<=0)
	   env->ThrowError("MVFlowFps: ML must be > 0.0");
	return new MVFlowFps(
		args[0].AsClip(),
		args[1].AsClip(),
		args[2].AsClip(),
      args[3].AsInt(25), // num
      args[4].AsInt(1), // den
      ml, // ml
      args[6].AsInt(mvCore.GetNextIdx()),
      args[7].AsInt(MV_DEFAULT_SCD1),
      args[8].AsInt(MV_DEFAULT_SCD2),
      args[9].AsBool(true),
      args[10].AsBool(true),
		env);
}

AVSValue __cdecl Create_MVFlowBlur(AVSValue args, void* user_data, IScriptEnvironment* env)
{
   double time = args[3].AsFloat(50.0);
	if (time<0 || time>200)
	   env->ThrowError("MVFlowBlur: Blur time must be from 0 to 200 percent.");
	int blur256 = int(time*256.0/200.0); 
	return new MVFlowBlur(
		args[0].AsClip(),
		args[1].AsClip(),
		args[2].AsClip(),
      blur256, 
      args[4].AsInt(1), // prec 
      args[5].AsInt(mvCore.GetNextIdx()),
      args[6].AsInt(MV_DEFAULT_SCD1),
      args[7].AsInt(MV_DEFAULT_SCD2),
      args[8].AsBool(true),
      args[9].AsBool(true),
		env);
}

AVSValue __cdecl Create_MVFlowFps2(AVSValue args, void* user_data, IScriptEnvironment* env)
{
	double ml = args[7].AsFloat(100);
	if (ml<=0)
	   env->ThrowError("MVFlowFps: ML must be > 0.0");
	return new MVFlowFps2(
		args[0].AsClip(),
		args[1].AsClip(),
		args[2].AsClip(),
		args[3].AsClip(),
		args[4].AsClip(),
      args[5].AsInt(25), // num
      args[6].AsInt(1), // den
      ml, // ml
      args[8].AsInt(mvCore.GetNextIdx()),
      args[9].AsInt(mvCore.GetNextIdx()),
      args[10].AsInt(MV_DEFAULT_SCD1),
      args[11].AsInt(MV_DEFAULT_SCD2),
      args[12].AsBool(true),
      args[13].AsBool(true),
		env);
}


extern "C" __declspec(dllexport) const char* __stdcall
AvisynthPluginInit2(IScriptEnvironment* env) {

	env->AddFunction("MVDenoise", "cc+[Y]b[U]b[V]b[thT]i[thSAD]i[thMV]i[thSCD1]i[thSCD2]i[mmx]b[isse]b", Create_MVDenoise2, 0);
	env->AddFunction("MVShow", "c[vectors]c[scale]i[sil]i[tol]i[showsad]b[thSCD1]i[thSCD2]i[mmx]b[isse]b", Create_MVShow, 0);
	//env->AddFunction("MVSpeed", "c[vectors]c[srcluma]b[refluma]b[var]b[compy]b[compu]b[compv]b[thSCD1]i[thSCD2]i[mmx]b[isse]b", Create_MVSpeed, 0);
	env->AddFunction("MVAnalyse", "c[blksize]i[pel]i[level]i[search]i[searchparam]i[isb]b[lambda]i[chroma]b[delta]i[mmx]b[isse]b[idx]i[truemotion]b[lsad]i[pnew]i[plevel]i[global]b[overlap]i", Create_MVAnalyse, 0);
	env->AddFunction("MVMask", "c[vectors]c[ml]f[gamma]f[kind]i[Ysc]i[thSCD1]i[thSCD2]i[mmx]b[isse]b", Create_MVMask, 0);
   //env->AddFunction("MVBidouille", "c[mvbw]c[mvfw]c[idx]i[boo]i[thSCD1]i[thSCD2]i[mmx]b[isse]b", Create_MVBidouille, 0);
	env->AddFunction("MVCompensate", "c[vectors]c[scbehavior]b[mode]i[idx]i[thSCD1]i[thSCD2]i[mmx]b[isse]b", Create_MVCompensate, 0);
   env->AddFunction("MVIncrease", "c[vectors]c[vertical]i[horizontal]i[scbehavior]b[idx]i[thSCD1]i[thSCD2]i[mmx]b[isse]b", Create_MVIncrease, 0);
   env->AddFunction("MVChangeCompensate", "cc[isse]b", Create_MVChangeCompensate, 0);
   env->AddFunction("MVSCDetection", "c[vectors]c[Yth]i[thSCD1]i[thSCD2]i[mmx]b[isse]b", Create_MVSCDetection, 0);
//	env->AddFunction("TestFilter","c", Create_TestFilter, 0);
//	env->AddFunction("Padding","c[hPad]i[vPad]i", Create_Padding, 0);
//   env->AddFunction("YUVSource","[file]s[width]i[height]i", Create_YUVSource, 0);
//   env->AddFunction("Corrector", "cc+[mode]i[th]i", Create_Corrector, 0);
//   env->AddFunction("Deblock", "c[quant]i[aOffset]i[bOffset]i[mmx]b[isse]b", Create_Deblock, 0);
	env->AddFunction("MVDepan", "c[vectors]c[zoom]b[rot]b[pixaspect]f[error]f[info]b[log]s[thSCD1]i[thSCD2]i[mmx]b[isse]b", Create_MVDepan, 0);
//	env->AddFunction("MVInter", "c[mvbw]c[mvfw]c[time]f[mode]i[thres]i[idx]i[thSCD1]i[thSCD2]i[mmx]b[isse]b", Create_MVInter, 0);
	env->AddFunction("MVFlow", "c[vectors]c[time]f[mode]i[idx]i[thSCD1]i[thSCD2]i[mmx]b[isse]b", Create_MVFlow, 0);
	env->AddFunction("MVFlowInter", "c[mvbw]c[mvfw]c[time]f[ml]f[idx]i[thSCD1]i[thSCD2]i[mmx]b[isse]b", Create_MVFlowInter, 0);
	env->AddFunction("MVFlowFps", "c[mvbw]c[mvfw]c[num]i[den]i[ml]f[idx]i[thSCD1]i[thSCD2]i[mmx]b[isse]b", Create_MVFlowFps, 0);
	env->AddFunction("MVFlowBlur", "c[mvbw]c[mvfw]c[blur]f[prec]i[idx]i[thSCD1]i[thSCD2]i[mmx]b[isse]b", Create_MVFlowBlur, 0);
	env->AddFunction("MVFlowFps2", "c[mvbw]c[mvfw]c[mvbw2]c[mvfw2]c[num]i[den]i[ml]f[idx]i[idx2]i[thSCD1]i[thSCD2]i[mmx]b[isse]b", Create_MVFlowFps2, 0);
	return("MVTools : set of tools based on a motion estimation engine");
}
