// Make a motion compensate temporal denoiser

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#ifndef __MV_ANALYSE__
#define __MV_ANALYSE__

#include "MVInterface.h"
#include "GroupOfPlanes.h"
#include "commonfunctions.h"
#include "yuy2planes.h"

class MVAnalyse : public GenericVideoFilter {
protected:
   MVAnalysisData analysisData;

	/*! \brief Frames of blocks for which motion vectors will be computed */
	GroupOfPlanes *vectorFields;

   /*! \brief mmx optimisations enabled */
   bool mmx;

   /*! \brief isse optimisations enabled */
	bool isse;

   /*! \brief motion vecteur cost factor */
   int nLambda;

   /*! \brief search type chosen for refinement in the EPZ */
   SearchType searchType;

   /*! \brief additionnal parameter for this search */
	int nSearchParam;

	int lsad; // SAD limit for lambda using - added by Fizick
	int pnew; // penalty to cost for new canditate - added by Fizick
	int plen; // penalty factor (similar to lambda) for vector length - added by Fizick
	int plevel; // penalty factors (lambda, plen) level scaling - added by Fizick
	bool global; // use global motion predictor

	YUY2Planes * SrcPlanes;
	YUY2Planes * RefPlanes;

public :

	MVAnalyse(PClip _child, int size, int pel, int lv, int st, int stp, bool isb,
             int lambda, bool chroma, int df, bool _mmx, bool _isse, int _idx, 
			 int _lsad, int _pnew, int _plevel, bool _globalmotion, int _nOverlap, IScriptEnvironment* env);
	~MVAnalyse();

   PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env);

};

#endif