// Make a motion compensate temporal denoiser

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#include "MVChangeCompensate.h"
#include "MVInterface.h"

MVChangeCompensate::MVChangeCompensate(PClip _child, PClip _video, bool _isse, IScriptEnvironment* env) :
GenericVideoFilter(_child), newCompensation(_video)
{
   MVAnalysisData *pAnalyseFilter = reinterpret_cast<MVAnalysisData *>(vi.nchannels);

   nLevelCount = pAnalyseFilter->GetLevelCount();
   nWidth = newCompensation->GetVideoInfo().width;
   nHeight = newCompensation->GetVideoInfo().height;
   pixelType = pAnalyseFilter->GetPixelType();
   yRatioUV = pAnalyseFilter->GetYRatioUV();
   isse = _isse;

   if ( (pixelType & VideoInfo::CS_YUY2) == VideoInfo::CS_YUY2 )
   {
		NewPlanes =  new YUY2Planes(nWidth, nHeight);
   }
}

MVChangeCompensate::~MVChangeCompensate()
{
   if ( (pixelType & VideoInfo::CS_YUY2) == VideoInfo::CS_YUY2 )
   {
	delete NewPlanes;
   }
}

PVideoFrame __stdcall MVChangeCompensate::GetFrame(int n, IScriptEnvironment* env)
{
	PVideoFrame	src	= child->GetFrame(n, env);
   PVideoFrame newframe = newCompensation->GetFrame(n, env);
   PVideoFrame dst = env->NewVideoFrame(vi);
    int nNewPitches[3];
	const unsigned char *pNewYUY2;
	unsigned char *pNew[3];
	int nNewPitchYUY2;

   const int *pSrc = reinterpret_cast<const int *>(src->GetReadPtr());
   const int *s = pSrc + 2;
   int nMvSize = 2;
   for ( int i = 0; i < nLevelCount; i++ )
   {
      nMvSize += s[0];
      s += s[0];
   }
   nMvSize++;
  
   nMvSize *= 4;

  		if ( (pixelType & VideoInfo::CS_YUY2) == VideoInfo::CS_YUY2 )
		{
			pNewYUY2 = newframe->GetReadPtr();
			nNewPitchYUY2 = newframe->GetPitch();
			pNew[0] = NewPlanes->GetPtr();
			pNew[1] = NewPlanes->GetPtrU();
			pNew[2] = NewPlanes->GetPtrV();
			nNewPitches[0]  = NewPlanes->GetPitch();
			nNewPitches[1]  = NewPlanes->GetPitchUV();
			nNewPitches[2]  = NewPlanes->GetPitchUV();
			YUY2ToPlanes(pNewYUY2, nNewPitchYUY2, nWidth, nHeight, 
				pNew[0], nNewPitches[0], pNew[1], pNew[2], nNewPitches[1], isse);
		}
		else
		{
			 pNew[0] = YWPLAN(newframe);
			 pNew[1] = UWPLAN(newframe);
			 pNew[2] = VWPLAN(newframe);
			 nNewPitches[0] = YPITCH(newframe);
			 nNewPitches[1] = UPITCH(newframe);
			 nNewPitches[2] = VPITCH(newframe);
		}
   env->BitBlt(dst->GetWritePtr(), nMvSize, src->GetReadPtr(), nMvSize, nMvSize, 1);
   env->BitBlt(dst->GetWritePtr() + nMvSize, nWidth, pNew[0], nNewPitches[0], nWidth, nHeight);
   env->BitBlt(dst->GetWritePtr() + nMvSize + nWidth * nHeight, nWidth / 2, pNew[1], nNewPitches[1], nWidth / 2, nHeight / yRatioUV);
   env->BitBlt(dst->GetWritePtr() + nMvSize + nWidth * nHeight + nWidth * nHeight / (2*yRatioUV), nWidth / 2, pNew[1], nNewPitches[1], nWidth / 2, nHeight / yRatioUV);

   return dst;
}