#include "MVInterface.h"

MVClip::MVClip(const PClip &vectors, int _nSCD1, int _nSCD2, IScriptEnvironment *env) :
GenericVideoFilter(vectors)
{
   // we fetch the handle on the analyze filter
   MVAnalysisData *pAnalyseFilter = reinterpret_cast<MVAnalysisData *>(vi.nchannels);

   // 'magic' key, just to check : 
   if ( pAnalyseFilter->GetMagicKey() != MOTION_MAGIC_KEY )
      env->ThrowError("GenericMotionFilter : unvalid vectors stream");

   // MVAnalysisData 
   nBlkSize = pAnalyseFilter->GetBlkSize();
   nPel = pAnalyseFilter->GetPel();
   isBackward = pAnalyseFilter->IsBackward();
   nLvCount = pAnalyseFilter->GetLevelCount();
   nDeltaFrame = pAnalyseFilter->GetDeltaFrame();
   nWidth = pAnalyseFilter->GetWidth();
   nHeight = pAnalyseFilter->GetHeight();
   nMagicKey = pAnalyseFilter->GetMagicKey();
   nIdx = pAnalyseFilter->GetFramesIdx();
   nOverlap = pAnalyseFilter->GetOverlap();
   pmvCore = pAnalyseFilter->GetMVCore();
   pixelType = pAnalyseFilter->GetPixelType();
   yRatioUV = pAnalyseFilter->GetYRatioUV();

   // MVClip
   nVPadding = nBlkSize;
   nHPadding = nBlkSize;
	nBlkX = pAnalyseFilter->GetBlkX();
	nBlkY = pAnalyseFilter->GetBlkY();
   nBlkCount = nBlkX * nBlkY;

   // SCD thresholds
   if ( pAnalyseFilter->IsChromaMotion() )
      nSCD1 = _nSCD1 * (nBlkSize * nBlkSize) / (8 * 8) * (1 + yRatioUV) / yRatioUV;
   else
      nSCD1 = _nSCD1 * (nBlkSize * nBlkSize) / (8 * 8);

   nSCD2 = _nSCD2 * nBlkCount / 256;

   // FakeGroupOfPlane creation
   FakeGroupOfPlanes::Create(nWidth, nHeight, nBlkSize, nLvCount, nPel, nOverlap, yRatioUV);
}

MVClip::~MVClip()
{
	FakeGroupOfPlanes::~FakeGroupOfPlanes(); //v1.2.1
}

void MVClip::SetVectorsNeed(bool srcluma, bool refluma, bool var,
                            bool compy, bool compu, bool compv) const
{
   int nFlags = 0;

   nFlags |= srcluma ? MOTION_CALC_SRC_LUMA        : 0;
   nFlags |= refluma ? MOTION_CALC_REF_LUMA        : 0;
   nFlags |= var     ? MOTION_CALC_VAR             : 0;
   nFlags |= compy   ? MOTION_COMPENSATE_LUMA      : 0;
   nFlags |= compu   ? MOTION_COMPENSATE_CHROMA_U  : 0;
   nFlags |= compv   ? MOTION_COMPENSATE_CHROMA_V  : 0;

   MVAnalysisData *pAnalyseFilter = reinterpret_cast<MVAnalysisData *>(vi.nchannels);
   pAnalyseFilter->SetFlags(nFlags);
}

void MVClip::Update(int n, IScriptEnvironment *env)
{
   FakeGroupOfPlanes::Update(reinterpret_cast<const int*>(child->GetFrame(n, env)->GetReadPtr()));
}

bool MVClip::IsUsable(int nSCD1, int nSCD2) const
{
   return (!FakeGroupOfPlanes::IsSceneChange(nSCD1, nSCD2)) && GetValidity();
}
