#include "MVInterface.h"

MVClipArray::MVClipArray(const AVSValue &vectors, int nSCD1, int nSCD2, IScriptEnvironment *env)
{
   DebugPrintf("Constructing mvClipArray... : %i", vectors.ArraySize());
   size_ = vectors.ArraySize();
   pmvClips = new MVClip*[size_];
   for ( int i = 0; i < size_; i++ )
      pmvClips[i] = new MVClip(vectors[i].AsClip(), nSCD1, nSCD2, env);
}

MVClipArray::~MVClipArray()
{
   for ( int i = 0; i < size_; i++ )
      delete pmvClips[i];
   delete[] pmvClips;
}

void MVClipArray::Update(int n, IScriptEnvironment *env)
{
   for ( int i = 0; i < size_; i++ )
      pmvClips[i]->Update(n, env);
}
