#ifndef __MV_COMPENSATE__
#define __MV_COMPENSATE__

#include "MVInterface.h"
#include "CopyCode.h"
#include "yuy2planes.h"

/*! \brief Filter that denoise the picture
 */
class MVCompensate : public GenericVideoFilter, public MVFilter {
private:

   MVClip mvClip;
   bool scBehavior;
   bool inLoop;
   bool inClip;
   unsigned char **pRefs;
   unsigned char **pRefsU;
   unsigned char **pRefsV;
   int nRefPitch;
   int nRefHeight;
   int nRefWidth;
   int nRefPitchUV;
   int nRefWidthUV;
   int nRefHeightUV;
   int nOffset;
   int nOffsetUV;
   bool isse;
   bool mmx;

   COPYFunction *BLITLUMA;
   COPYFunction *BLITCHROMA;

   void MoveBlock(unsigned char *pDst, int nDstPitch, int x, int y, int mvx, int mvy);
   void MoveBlockU(unsigned char *pDst, int nDstPitch, int x, int y, int mvx, int mvy);
   void MoveBlockV(unsigned char *pDst, int nDstPitch, int x, int y, int mvx, int mvy);

   YUY2Planes * RefPlanes;
	YUY2Planes * DstPlanes;
 
public:
	MVCompensate(PClip _child, PClip vectors, bool sc, bool inclip, bool inloop, int _nIdx,
                int nSCD1, int nSCD2, bool mmx, bool isse, IScriptEnvironment* env);
	~MVCompensate();
	PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env);
};

#endif