#include "MVInterface.h"

#ifdef MOTION_PROFILE
int ProfTimeTable[MOTION_PROFILE_COUNT];
int ProfResults[MOTION_PROFILE_COUNT * 2];
__int64 ProfCumulatedResults[MOTION_PROFILE_COUNT * 2];
#endif

MVCore::MVCore()
{
   pFramesList = new MVFramesList();
   nAutoIdx = 0;

   DebugPrintf("Creation of mvCore\n");
   DebugPrintf("mvCore own adresse : %i\n", this);

   PROFILE_INIT();
}

MVCore::~MVCore()
{
   if (pFramesList)
      delete pFramesList;

   DebugPrintf("Destruction of mvCore");
   DebugPrintf("mvCore own adresse : %i\n", this);

   PROFILE_SHOW();
}

void MVCore::AddFrames(int nIdx, int nNbFrames, int nLevelCount, int nWidth,
                       int nHeight, int nPel, int nHPad, int nVPad, int nMode, bool isse, int yRatioUV)
{
   DebugPrintf("Add frames list, with %i as idx %i\n", nIdx, pFramesList);
   if ( !pFramesList->GetFrames(nIdx) )
   {
      DebugPrintf("Idx not found, creating a new list of frames...\n");
      pFramesList = new MVFramesList(pFramesList, nIdx, nNbFrames, nLevelCount, nWidth,
                                     nHeight, nPel, nHPad, nVPad, nMode, isse, yRatioUV);
   }
   else
   {
      DebugPrintf("Idx already found, no need to add a list of frames\n");
   }
   DebugPrintf("mvCore own adresse : %i\n", this);
}

MVFrames *MVCore::GetFrames(int nIdx)
{
   return pFramesList->GetFrames(nIdx);
}
