// Make a motion compensate temporal denoiser

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#ifndef __MVDENOISE2__
#define __MVDENOISE2__

#include "MVInterface.h"
#include "yuy2planes.h"

/*! \brief Filter that denoise the picture
 */
class MVDenoise2 : public GenericVideoFilter, public MVFilter {
private:
	/*! \brief Temporal threshold. After the motion compensation, we check again that threshold
	 *	that the pixel has not varied to much. If it has, we discard the compensation.
	 */
	int TemporalThreshold;

	int SADThreshold;

	int MVThreshold;

	int pitch;

	int size;

	int offset;

   int nMvCount;

   MVClipArray mvClipArray;

   int nMode;
   bool isse;

protected:
	//void DenoiseBlock(unsigned char *derp, int der_pitch);
   void DenoiseBlockLuma(unsigned char *pDst, int nDstPitch);
   void DenoiseBlockChromaU(unsigned char *pDst, int nDstPitch);
   void DenoiseBlockChromaV(unsigned char *pDst, int nDstPitch);
	inline int MABS(int x) { return ( x < 0 ) ? -x : x; }

	YUY2Planes * DstPlanes;

public:
	MVDenoise2(PClip _child, AVSValue mvArray, int _nMode, int thT, int sadT, int thMV, int nSCD1, int nSCD2, bool mmx, bool isse, IScriptEnvironment* env);
	~MVDenoise2();
	PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env);
};

#endif