#include "MVInterface.h"

MVFilter::MVFilter(const PClip &vector, const char *filterName, IScriptEnvironment *env)
{
   MVClip mvClip(vector, 0, 0, env);

   nWidth = mvClip.GetWidth();
   nHeight = mvClip.GetHeight();
   nHPadding = mvClip.GetHPadding();
   nVPadding = mvClip.GetVPadding();
   nBlkCount = mvClip.GetBlkCount();
   nBlkSize = mvClip.GetBlkSize();
   nIdx = mvClip.GetFramesIdx();
   nBlkX = mvClip.GetBlkX();
   nBlkY = mvClip.GetBlkY();
   nPel = mvClip.GetPel();
   mvCore = mvClip.GetMVCore();
   nOverlap = mvClip.GetOverlap();
   pixelType = mvClip.GetPixelType();
   yRatioUV = mvClip.GetYRatioUV();

   name = filterName;
}

void MVFilter::CheckSimilarity(const MVClip &vector, const char *vectorName, IScriptEnvironment *env)
{
   if ( nWidth != vector.GetWidth() )
      env->ThrowError("Error in %s : %s's width is incorrect", name.c_str(), vectorName);

   if ( nHeight != vector.GetHeight() )
      env->ThrowError("Error in %s : %s's height is incorrect", name.c_str(), vectorName);

   if ( nBlkSize != vector.GetBlkSize() )
      env->ThrowError("Error in %s : %s's block size is incorrect", name.c_str(), vectorName);
}