// Pixels flow motion interpolation function to change FPS
// Copyright(c)2005 A.G.Balakhnin aka Fizick

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#include "MVFlowFps.h"
#include "CopyCode.h"
#include "MaskFun.h"


MVFlowFps::MVFlowFps(PClip _child, PClip _mvbw, PClip _mvfw,  int _num, int _den, double _ml, int _nIdx,
                           int nSCD1, int nSCD2, bool _mmx, bool _isse, IScriptEnvironment* env) :
GenericVideoFilter(_child),
MVFilter(_mvbw, "MVFlowFps", env),
mvClipB(_mvbw, nSCD1, nSCD2, env),
mvClipF(_mvfw, nSCD1, nSCD2, env)
{
	numerator = _num;
	denominator = _den;
	numeratorOld = vi.fps_numerator;
	denominatorOld = vi.fps_denominator;

	vi.fps_numerator = numerator;
	vi.fps_denominator = denominator;
	vi.num_frames = (int)(1 + __int64(vi.num_frames-1) * numerator*denominatorOld/(denominator*numeratorOld) );

   ml = _ml;
   nIdx = _nIdx;
   mmx = _mmx;
   isse = _isse;

     mvCore->AddFrames(nIdx, MV_BUFFER_FRAMES, mvClipB.GetLevelCount(), nWidth, nHeight,
                        nPel, nBlkSize, nBlkSize, YUVPLANES, isse, yRatioUV);
     mvCore->AddFrames(nIdx, MV_BUFFER_FRAMES, mvClipF.GetLevelCount(), nWidth, nHeight,
                        nPel, nBlkSize, nBlkSize, YUVPLANES, isse, yRatioUV);

	 // may be padded for full frame cover
	 nBlkXP = (nBlkX*(nBlkSize - nOverlap) + nOverlap < nWidth) ? nBlkX+1 : nBlkX;
	 nBlkYP = (nBlkY*(nBlkSize - nOverlap) + nOverlap < nHeight) ? nBlkY+1 : nBlkY;
	 nWidthP = nBlkXP*(nBlkSize - nOverlap) + nOverlap;
	 nHeightP = nBlkYP*(nBlkSize - nOverlap) + nOverlap;
	 // for YV12
	 nWidthPUV = nWidthP/2;
	 nHeightPUV = nHeightP/yRatioUV; 
	 nHeightUV = nHeight/yRatioUV; 
	 nWidthUV = nWidth/2;
	 int nHPaddingUV = nHPadding/2;
	 int nVPaddingUV = nVPadding/yRatioUV;

	 VPitchY = (nWidthP + 15) & (~15);
	 VPitchUV = (nWidthPUV + 15) & (~15);

 	 VXFullYB = new BYTE [nHeightP*VPitchY]; 
	 VXFullUVB = new BYTE [nHeightPUV*VPitchUV];
 	 VYFullYB = new BYTE [nHeightP*VPitchY];
	 VYFullUVB = new BYTE [nHeightPUV*VPitchUV];

	 VXFullYF = new BYTE [nHeightP*VPitchY]; 
	 VXFullUVF = new BYTE [nHeightPUV*VPitchUV];
 	 VYFullYF = new BYTE [nHeightP*VPitchY];
	 VYFullUVF = new BYTE [nHeightPUV*VPitchUV];

  	 VXSmallYB = new BYTE [nBlkXP*nBlkYP];
  	 VYSmallYB = new BYTE [nBlkXP*nBlkYP];
	 VXSmallUVB = new BYTE [nBlkXP*nBlkYP]; 
	 VYSmallUVB = new BYTE [nBlkXP*nBlkYP]; 

  	 VXSmallYF = new BYTE [nBlkXP*nBlkYP];
  	 VYSmallYF = new BYTE [nBlkXP*nBlkYP];
	 VXSmallUVF = new BYTE [nBlkXP*nBlkYP]; 
	 VYSmallUVF = new BYTE [nBlkXP*nBlkYP]; 

	 MaskSmallB = new BYTE [nBlkXP*nBlkYP]; 
	 MaskFullYB = new BYTE [nHeightP*VPitchY]; 
	 MaskFullUVB = new BYTE [nHeightPUV*VPitchUV]; 

	 MaskSmallF = new BYTE [nBlkXP*nBlkYP]; 
	 MaskFullYF = new BYTE [nHeightP*VPitchY]; 
	 MaskFullUVF = new BYTE [nHeightPUV*VPitchUV]; 


	 int pel2WidthY = (nWidth + 2*nHPadding)*nPel; 
	 pel2HeightY = (nHeight + 2*nVPadding)*nPel;
	 int pel2WidthUV = (nWidthUV + 2*nHPaddingUV)*nPel;
	 pel2HeightUV = (nHeightUV + 2*nVPaddingUV)*nPel;
	pel2PitchY = (pel2WidthY + 15) & (~15);
   	pel2PitchUV = (pel2WidthUV + 15) & (~15);
    pel2OffsetY = pel2PitchY * nVPadding*nPel + nHPadding*nPel;
    pel2OffsetUV = pel2PitchUV * nVPaddingUV*nPel + nHPaddingUV*nPel;
	 if (nPel>1)
	 {
		 pel2PlaneYB = new BYTE [pel2PitchY*pel2HeightY];
		 pel2PlaneUB = new BYTE [pel2PitchUV*pel2HeightUV];
		 pel2PlaneVB = new BYTE [pel2PitchUV*pel2HeightUV];
		 pel2PlaneYF = new BYTE [pel2PitchY*pel2HeightY];
		 pel2PlaneUF = new BYTE [pel2PitchUV*pel2HeightUV];
		 pel2PlaneVF = new BYTE [pel2PitchUV*pel2HeightUV];
	 }

	 int CPUF_Resize = env->GetCPUFlags();
	 if (!isse) CPUF_Resize = (CPUF_Resize & !CPUF_INTEGER_SSE) & !CPUF_SSE2;

	 upsizer = new SimpleResize(nWidthP, nHeightP, nBlkXP, nBlkYP, CPUF_Resize); 
	 upsizerUV = new SimpleResize(nWidthPUV, nHeightPUV, nBlkXP, nBlkYP, CPUF_Resize); 

	 LUTVB = new int[256];
	 LUTVF = new int[256];

	nleftLast = -1000;
	 nrightLast = -1000;

	 if ( (pixelType & VideoInfo::CS_YUY2) == VideoInfo::CS_YUY2 )
   {
		SrcPlanes =  new YUY2Planes(nWidth, nHeight);
		RefPlanes =  new YUY2Planes(nWidth, nHeight);
		DstPlanes =  new YUY2Planes(nWidth, nHeight);
   }

}

MVFlowFps::~MVFlowFps()
{
   if ( (pixelType & VideoInfo::CS_YUY2) == VideoInfo::CS_YUY2 )
   {
	delete SrcPlanes;
	delete RefPlanes;
	delete DstPlanes;
   }

	delete upsizer;
	delete upsizerUV;

	delete VXFullYB;
	delete VXFullUVB;
	delete VYFullYB;
	delete VYFullUVB;
	delete VXSmallYB;
	delete VYSmallYB;
	delete VXSmallUVB;
	delete VYSmallUVB;
	delete VXFullYF;
	delete VXFullUVF;
	delete VYFullYF;
	delete VYFullUVF;
	delete VXSmallYF;
	delete VYSmallYF;
	delete VXSmallUVF;
	delete VYSmallUVF;

	delete MaskSmallB;
	delete MaskFullYB;
	delete MaskFullUVB;
	delete MaskSmallF;
	delete MaskFullYF;
	delete MaskFullUVF;
	 if (nPel>1)
	 {
		 delete pel2PlaneYB; 
		 delete pel2PlaneUB; 
		 delete pel2PlaneVB; 
		 delete pel2PlaneYF; 
		 delete pel2PlaneUF; 
		 delete pel2PlaneVF; 
	 }
	 delete LUTVB;
	 delete LUTVF;

}

void MVFlowFps::Create_LUTV(int time256, int *LUTVB, int *LUTVF)
{
	for (int v=0; v<256; v++)
	{
		LUTVB[v] = ((v-128)*(256-time256))/256;
		LUTVF[v] = ((v-128)*time256)/256;
	}
}


void MVFlowFps::FlowInter(BYTE * pdst, int dst_pitch, const BYTE *prefB, const BYTE *prefF, int ref_pitch,  
			   BYTE *VXFullB, BYTE *VXFullF, BYTE *VYFullB, BYTE *VYFullF, BYTE *MaskB, BYTE *MaskF,
			   int VPitch, int width, int height, int time256)
{
	if (nPel==1)
	{
		for (int h=0; h<height; h++)
		{
			for (int w=0; w<width; w++)
			{
//				int vxF = ((VXFullF[w]-128)*time256)/256;
//				int vyF = ((VYFullF[w]-128)*time256)/256;
				int vxF = LUTVF[VXFullF[w]];
				int vyF = LUTVF[VYFullF[w]];
				int dstF = prefF[vyF*ref_pitch + vxF + w]; 
//				int vxB = ((VXFullB[w]-128)*(256-time256))/256;
//				int vyB = ((VYFullB[w]-128)*(256-time256))/256;
				int vxB = LUTVB[VXFullB[w]];
				int vyB = LUTVB[VYFullB[w]];
				int dstB = prefB[vyB*ref_pitch + vxB + w]; 
				pdst[w] = ( ( (dstF*(255-MaskF[w]) + dstB*MaskF[w] + 255)>>8 )*(256-time256) + 
				            ( (dstB*(255-MaskB[w]) + dstF*MaskB[w] + 255)>>8 )*time256 )>>8;
			}
			pdst += dst_pitch;
			prefB += ref_pitch;
			prefF += ref_pitch;
			VXFullB += VPitch;
			VYFullB += VPitch;
			VXFullF += VPitch;
			VYFullF += VPitch;
			MaskB += VPitch;
			MaskF += VPitch;
		}
	}
	else if (nPel==2)
	{
		for (int h=0; h<height; h++)
		{
			for (int w=0; w<width; w++)
			{
//				int vxF = ((VXFullF[w]-128)*time256)/256;
//				int vyF = ((VYFullF[w]-128)*time256)/256;
				int vxF = LUTVF[VXFullF[w]];
				int vyF = LUTVF[VYFullF[w]];
				int dstF = prefF[vyF*ref_pitch + vxF + (w<<1)]; 
//				int vxB = ((VXFullB[w]-128)*(256-time256))/256;
//				int vyB = ((VYFullB[w]-128)*(256-time256))/256;
				int vxB = LUTVB[VXFullB[w]];
				int vyB = LUTVB[VYFullB[w]];
				int dstB = prefB[vyB*ref_pitch + vxB + (w<<1)]; 
				pdst[w] = ( ( (dstF*(255-MaskF[w]) + dstB*MaskF[w] + 255)>>8 )*(256-time256) + 
				            ( (dstB*(255-MaskB[w]) + dstF*MaskB[w] + 255)>>8 )*time256 )>>8;
			}
			pdst += dst_pitch;
			prefB += ref_pitch<<1;
			prefF += ref_pitch<<1;
			VXFullB += VPitch;
			VYFullB += VPitch;
			VXFullF += VPitch;
			VYFullF += VPitch;
			MaskB += VPitch;
			MaskF += VPitch;
		}
	}
}
//-------------------------------------------------------------------------
PVideoFrame __stdcall MVFlowFps::GetFrame(int n, IScriptEnvironment* env)
{
	int nleft = (__int64) (__int64(n)* __int64(denominator)* __int64(numeratorOld))/( __int64(numerator)*__int64(denominatorOld)); 
	// intermediate product may be very large! Now I know how to multiply int64 
	time256 = int( (double(n)*double(denominator)*double(numeratorOld)/double(numerator)/double(denominatorOld) - nleft)*256 + 0.5);

	PVideoFrame	src	= child->GetFrame(nleft, env);
   PVideoFrame dst;
   BYTE *pDst[3];
	const BYTE *pRef[3], *pSrc[3];
    int nDstPitches[3], nRefPitches[3], nSrcPitches[3];
	unsigned char *pDstYUY2;
	int nDstPitchYUY2;


	int off = mvClipB.GetDeltaFrame(); // integer offset of reference frame

	int nright = nleft+off; // really off must be = 1

	PVideoFrame ref = child->GetFrame(nright, env);//  right frame for  compensation

	if (time256 ==0)
		return src; // simply left
	else if (time256==256)
		return ref; // simply right

	Create_LUTV(time256, LUTVB, LUTVF); // lookup table

	mvClipB.Update(nleft, env);// backward from next to current
	mvClipF.Update(nright, env);// forward from current to next


   if ( mvClipB.IsUsable()  && mvClipF.IsUsable() )
   {
		dst = env->NewVideoFrame(vi);

		MVFrames *pFrames = mvCore->GetFrames(nIdx);
          MVGroupOfFrames *pRefGOFF = pFrames->GetFrame(nleft); // forward ref
         MVGroupOfFrames *pRefGOFB = pFrames->GetFrame(nright); // backward ref

		if ( (pixelType & VideoInfo::CS_YUY2) == VideoInfo::CS_YUY2 )
		{
			const unsigned char *pSrcYUY2 = src->GetReadPtr();
			int nSrcPitchYUY2 = src->GetPitch();
			pSrc[0] = SrcPlanes->GetPtr();
			pSrc[1] = SrcPlanes->GetPtrU();
			pSrc[2] = SrcPlanes->GetPtrV();
			nSrcPitches[0]  = SrcPlanes->GetPitch();
			nSrcPitches[1]  = SrcPlanes->GetPitchUV();
			nSrcPitches[2]  = SrcPlanes->GetPitchUV();
			YUY2ToPlanes(pSrcYUY2, nSrcPitchYUY2, nWidth, nHeight, 
				pSrc[0], nSrcPitches[0], pSrc[1], pSrc[2], nSrcPitches[1], isse);

			const unsigned char *pRefYUY2 = ref->GetReadPtr();
			int nRefPitchYUY2 = ref->GetPitch();
			pRef[0] = RefPlanes->GetPtr();
			pRef[1] = RefPlanes->GetPtrU();
			pRef[2] = RefPlanes->GetPtrV();
			nRefPitches[0]  = RefPlanes->GetPitch();
			nRefPitches[1]  = RefPlanes->GetPitchUV();
			nRefPitches[2]  = RefPlanes->GetPitchUV();
			YUY2ToPlanes(pRefYUY2, nRefPitchYUY2, nWidth, nHeight, 
				pRef[0], nRefPitches[0], pRef[1], pRef[2], nRefPitches[1], isse);

			pDstYUY2 = dst->GetWritePtr();
			nDstPitchYUY2 = dst->GetPitch();
			pDst[0] = DstPlanes->GetPtr();
			pDst[1] = DstPlanes->GetPtrU();
			pDst[2] = DstPlanes->GetPtrV();
			nDstPitches[0]  = DstPlanes->GetPitch();
			nDstPitches[1]  = DstPlanes->GetPitchUV();
			nDstPitches[2]  = DstPlanes->GetPitchUV();
			YUY2ToPlanes(pDstYUY2, nDstPitchYUY2, nWidth, nHeight, 
				pDst[0], nDstPitches[0], pDst[1], pDst[2], nDstPitches[1], isse);
		}
		else
		{
         pDst[0] = YWPLAN(dst);
         pDst[1] = UWPLAN(dst);
         pDst[2] = VWPLAN(dst);
         nDstPitches[0] = YPITCH(dst);
         nDstPitches[1] = UPITCH(dst);
         nDstPitches[2] = VPITCH(dst);

         pRef[0] = YRPLAN(ref);
         pRef[1] = URPLAN(ref);
         pRef[2] = VRPLAN(ref);
         nRefPitches[0] = YPITCH(ref);
         nRefPitches[1] = UPITCH(ref);
         nRefPitches[2] = VPITCH(ref);

         pSrc[0] = YRPLAN(src);
         pSrc[1] = URPLAN(src);
         pSrc[2] = VRPLAN(src);
         nSrcPitches[0] = YPITCH(src);
         nSrcPitches[1] = UPITCH(src);
         nSrcPitches[2] = VPITCH(src);
		}

         pRefGOFF->SetPlane(pSrc[0], nSrcPitches[0], YPLANE);
         pRefGOFF->SetPlane(pSrc[1], nSrcPitches[1], UPLANE);
         pRefGOFF->SetPlane(pSrc[2], nSrcPitches[2], VPLANE);
         pRefGOFF->Pad(YUVPLANES);
         pRefGOFF->Refine(YUVPLANES);

         pRefGOFB->SetPlane(pRef[0], nRefPitches[0], YPLANE);
         pRefGOFB->SetPlane(pRef[1], nRefPitches[1], UPLANE);
         pRefGOFB->SetPlane(pRef[2], nRefPitches[2], VPLANE);
         pRefGOFB->Pad(YUVPLANES);
         pRefGOFB->Refine(YUVPLANES);

         MVPlane *pPlanesB[3];
         MVPlane *pPlanesF[3];

         pPlanesB[0] = pRefGOFB->GetFrame(0)->GetPlane(YPLANE);
         pPlanesB[1] = pRefGOFB->GetFrame(0)->GetPlane(UPLANE);
         pPlanesB[2] = pRefGOFB->GetFrame(0)->GetPlane(VPLANE);

         pPlanesF[0] = pRefGOFF->GetFrame(0)->GetPlane(YPLANE);
         pPlanesF[1] = pRefGOFF->GetFrame(0)->GetPlane(UPLANE);
         pPlanesF[2] = pRefGOFF->GetFrame(0)->GetPlane(VPLANE);


		 if (nPel==2)
		 {
			 // merge refined planes to big single plane
			 if (nright != nrightLast)
			 {
			 Merge4PlanesToBig(pel2PlaneYB, pel2PitchY, pPlanesB[0]->GetAbsolutePointer(0,0), 
				 pPlanesB[0]->GetAbsolutePointer(1,0), pPlanesB[0]->GetAbsolutePointer(0,1),
				 pPlanesB[0]->GetAbsolutePointer(1,1), pPlanesB[0]->GetExtendedWidth(),
				 pPlanesB[0]->GetExtendedHeight(), pPlanesB[0]->GetPitch(), isse);
			 Merge4PlanesToBig(pel2PlaneUB, pel2PitchUV, pPlanesB[1]->GetAbsolutePointer(0,0), 
				 pPlanesB[1]->GetAbsolutePointer(1,0), pPlanesB[1]->GetAbsolutePointer(0,1),
				 pPlanesB[1]->GetAbsolutePointer(1,1), pPlanesB[1]->GetExtendedWidth(),
				 pPlanesB[1]->GetExtendedHeight(), pPlanesB[1]->GetPitch(), isse);
			 Merge4PlanesToBig(pel2PlaneVB, pel2PitchUV, pPlanesB[2]->GetAbsolutePointer(0,0), 
				 pPlanesB[2]->GetAbsolutePointer(1,0), pPlanesB[2]->GetAbsolutePointer(0,1),
				 pPlanesB[2]->GetAbsolutePointer(1,1), pPlanesB[2]->GetExtendedWidth(),
				 pPlanesB[2]->GetExtendedHeight(), pPlanesB[2]->GetPitch(), isse);
			 }

			 if(nleft != nleftLast)
			 {
			 Merge4PlanesToBig(pel2PlaneYF, pel2PitchY, pPlanesF[0]->GetAbsolutePointer(0,0), 
				 pPlanesF[0]->GetAbsolutePointer(1,0), pPlanesF[0]->GetAbsolutePointer(0,1),
				 pPlanesF[0]->GetAbsolutePointer(1,1), pPlanesF[0]->GetExtendedWidth(),
				 pPlanesF[0]->GetExtendedHeight(), pPlanesF[0]->GetPitch(), isse);
			 Merge4PlanesToBig(pel2PlaneUF, pel2PitchUV, pPlanesF[1]->GetAbsolutePointer(0,0), 
				 pPlanesF[1]->GetAbsolutePointer(1,0), pPlanesF[1]->GetAbsolutePointer(0,1),
				 pPlanesF[1]->GetAbsolutePointer(1,1), pPlanesF[1]->GetExtendedWidth(),
				 pPlanesF[1]->GetExtendedHeight(), pPlanesF[1]->GetPitch(), isse);
			 Merge4PlanesToBig(pel2PlaneVF, pel2PitchUV, pPlanesF[2]->GetAbsolutePointer(0,0), 
				 pPlanesF[2]->GetAbsolutePointer(1,0), pPlanesF[2]->GetAbsolutePointer(0,1),
				 pPlanesF[2]->GetAbsolutePointer(1,1), pPlanesF[2]->GetExtendedWidth(),
				 pPlanesF[2]->GetExtendedHeight(), pPlanesF[2]->GetPitch(), isse);
			 }

		 }


		int dummyplane = PLANAR_Y; // use luma plane resizer code for all planes if we resize from luma small mask

		 if (nright != nrightLast)
		 {
			// make  vector vx and vy small masks
			// 1. ATTENTION: vectors are assumed SHORT (|vx|, |vy| < 127) !
			// 2. they will be zeroed if not
			// 3. added 128 to all values
			MakeVectorSmallMasks(mvClipB, nBlkX, nBlkY, VXSmallYB, nBlkXP, VYSmallYB, nBlkXP);
			if (nBlkXP > nBlkX) // fill right
			{
				for (int j=0; j<nBlkY; j++)
				{
					VXSmallYB[j*nBlkXP + nBlkX] = min(VXSmallYB[j*nBlkXP + nBlkX-1],128);
					VYSmallYB[j*nBlkXP + nBlkX] = VYSmallYB[j*nBlkXP + nBlkX-1];
				}
			}
			if (nBlkYP > nBlkY) // fill bottom
			{
				for (int i=0; i<nBlkXP; i++)
				{
					VXSmallYB[nBlkXP*nBlkY +i] = VXSmallYB[nBlkXP*(nBlkY-1) +i];
					VYSmallYB[nBlkXP*nBlkY +i] = min(VYSmallYB[nBlkXP*(nBlkY-1) +i],128);
				}
			}
			VectorSmallMaskYToHalfUV(VXSmallYB, nBlkXP, nBlkYP, VXSmallUVB, 2);
			VectorSmallMaskYToHalfUV(VYSmallYB, nBlkXP, nBlkYP, VYSmallUVB, yRatioUV);

			// upsize (bilinear interpolate) vector masks to fullframe size

		  upsizer->SimpleResizeDo(VXFullYB, nWidthP, nHeightP, VPitchY, VXSmallYB, nBlkXP, nBlkXP, dummyplane);
		  upsizer->SimpleResizeDo(VYFullYB, nWidthP, nHeightP, VPitchY, VYSmallYB, nBlkXP, nBlkXP, dummyplane);
		  upsizerUV->SimpleResizeDo(VXFullUVB, nWidthPUV, nHeightPUV, VPitchUV, VXSmallUVB, nBlkXP, nBlkXP, dummyplane);
		  upsizerUV->SimpleResizeDo(VYFullUVB, nWidthPUV, nHeightPUV, VPitchUV, VYSmallUVB, nBlkXP, nBlkXP, dummyplane);

		 }
		// analyse vectors field to detect occlusion
		double occNormB = (256-time256)/(256*ml);
		MakeVectorOcclusionMask(mvClipB, nBlkX, nBlkY, occNormB, 1.0, nPel, MaskSmallB, nBlkXP);
		if (nBlkXP > nBlkX) // fill right
		{
			for (int j=0; j<nBlkY; j++)
			{
				MaskSmallB[j*nBlkXP + nBlkX] = MaskSmallB[j*nBlkXP + nBlkX-1];
			}
		}
		if (nBlkYP > nBlkY) // fill bottom
		{
			for (int i=0; i<nBlkXP; i++)
			{
				MaskSmallB[nBlkXP*nBlkY +i] = MaskSmallB[nBlkXP*(nBlkY-1) +i];
			}
		}
	    upsizer->SimpleResizeDo(MaskFullYB, nWidthP, nHeightP, VPitchY, MaskSmallB, nBlkXP, nBlkXP, dummyplane);
		upsizerUV->SimpleResizeDo(MaskFullUVB, nWidthPUV, nHeightPUV, VPitchUV, MaskSmallB, nBlkXP, nBlkXP, dummyplane);

		 nrightLast = nright;


		 if(nleft != nleftLast)
		 {
			// make  vector vx and vy small masks
			// 1. ATTENTION: vectors are assumed SHORT (|vx|, |vy| < 127) !
			// 2. they will be zeroed if not
			// 3. added 128 to all values
			MakeVectorSmallMasks(mvClipF, nBlkX, nBlkY, VXSmallYF, nBlkXP, VYSmallYF, nBlkXP);
			if (nBlkXP > nBlkX) // fill right
			{
				for (int j=0; j<nBlkY; j++)
				{
					VXSmallYF[j*nBlkXP + nBlkX] = min(VXSmallYF[j*nBlkXP + nBlkX-1],128);
					VYSmallYF[j*nBlkXP + nBlkX] = VYSmallYF[j*nBlkXP + nBlkX-1];
				}
			}
			if (nBlkYP > nBlkY) // fill bottom
			{
				for (int i=0; i<nBlkXP; i++)
				{
					VXSmallYF[nBlkXP*nBlkY +i] = VXSmallYF[nBlkXP*(nBlkY-1) +i];
					VYSmallYF[nBlkXP*nBlkY +i] = min(VYSmallYF[nBlkXP*(nBlkY-1) +i],128);
				}
			}
			VectorSmallMaskYToHalfUV(VXSmallYF, nBlkXP, nBlkYP, VXSmallUVF, 2);
			VectorSmallMaskYToHalfUV(VYSmallYF, nBlkXP, nBlkYP, VYSmallUVF, yRatioUV);

			// upsize (bilinear interpolate) vector masks to fullframe size

		  upsizer->SimpleResizeDo(VXFullYF, nWidthP, nHeightP, VPitchY, VXSmallYF, nBlkXP, nBlkXP, dummyplane);
		  upsizer->SimpleResizeDo(VYFullYF, nWidthP, nHeightP, VPitchY, VYSmallYF, nBlkXP, nBlkXP, dummyplane);
		  upsizerUV->SimpleResizeDo(VXFullUVF, nWidthPUV, nHeightPUV, VPitchUV, VXSmallUVF, nBlkXP, nBlkXP, dummyplane);
		  upsizerUV->SimpleResizeDo(VYFullUVF, nWidthPUV, nHeightPUV, VPitchUV, VYSmallUVF, nBlkXP, nBlkXP, dummyplane);

		 }
		// analyse vectors field to detect occlusion
		double occNormF = time256/(256*ml);
		MakeVectorOcclusionMask(mvClipF, nBlkX, nBlkY, occNormF, 1.0, nPel, MaskSmallF, nBlkXP);
		if (nBlkXP > nBlkX) // fill right
		{
			for (int j=0; j<nBlkY; j++)
			{
				MaskSmallF[j*nBlkXP + nBlkX] = MaskSmallF[j*nBlkXP + nBlkX-1];
			}
		}
		if (nBlkYP > nBlkY) // fill bottom
		{
			for (int i=0; i<nBlkXP; i++)
			{
				MaskSmallF[nBlkXP*nBlkY +i] = MaskSmallF[nBlkXP*(nBlkY-1) +i];
			}
		}

	    upsizer->SimpleResizeDo(MaskFullYF, nWidthP, nHeightP, VPitchY, MaskSmallF, nBlkXP, nBlkXP, dummyplane);
		upsizerUV->SimpleResizeDo(MaskFullUVF, nWidthPUV, nHeightPUV, VPitchUV, MaskSmallF, nBlkXP, nBlkXP, dummyplane);

		 nleftLast = nleft;


		  if (nPel==2)
		  {
			FlowInter(pDst[0], nDstPitches[0], pel2PlaneYB + pel2OffsetY, pel2PlaneYF + pel2OffsetY, pel2PitchY, 
				VXFullYB, VXFullYF, VYFullYB, VYFullYF, MaskFullYB, MaskFullYF, VPitchY, 
				nWidth, nHeight, time256);
			FlowInter(pDst[1], nDstPitches[1], pel2PlaneUB + pel2OffsetUV, pel2PlaneUF + pel2OffsetUV, pel2PitchUV,
				VXFullUVB, VXFullUVF, VYFullUVB, VYFullUVF, MaskFullUVB, MaskFullUVF, VPitchUV, 
				nWidthUV, nHeightUV, time256);
			FlowInter(pDst[2], nDstPitches[2], pel2PlaneVB + pel2OffsetUV, pel2PlaneVF + pel2OffsetUV, pel2PitchUV, 
				VXFullUVB, VXFullUVF, VYFullUVB, VYFullUVF, MaskFullUVB, MaskFullUVF, VPitchUV, 
				nWidthUV, nHeightUV, time256);

		  }
		  else if (nPel==1)
		  {
			FlowInter(pDst[0], nDstPitches[0], pPlanesB[0]->GetPointer(0,0), pPlanesF[0]->GetPointer(0,0), pPlanesB[0]->GetPitch(), 
				VXFullYB, VXFullYF, VYFullYB, VYFullYF, MaskFullYB, MaskFullYF, VPitchY, 
				nWidth, nHeight, time256);
			FlowInter(pDst[1], nDstPitches[1], pPlanesB[1]->GetPointer(0,0), pPlanesF[1]->GetPointer(0,0), pPlanesB[1]->GetPitch(), 
				VXFullUVB, VXFullUVF, VYFullUVB, VYFullUVF, MaskFullUVB, MaskFullUVF, VPitchUV, 
				nWidthUV, nHeightUV, time256);
			FlowInter(pDst[2], nDstPitches[2], pPlanesB[2]->GetPointer(0,0), pPlanesF[2]->GetPointer(0,0), pPlanesB[2]->GetPitch(), 
				VXFullUVB, VXFullUVF, VYFullUVB, VYFullUVF, MaskFullUVB, MaskFullUVF, VPitchUV, 
				nWidthUV, nHeightUV, time256);
		  }

		if ( (pixelType & VideoInfo::CS_YUY2) == VideoInfo::CS_YUY2 )
		{
			YUY2FromPlanes(pDstYUY2, nDstPitchYUY2, nWidth, nHeight,
								  pDst[0], nDstPitches[0], pDst[1], pDst[2], nDstPitches[1], isse);
		}
		return dst;		 
   }
   else 
   {
	   return src;
   }

}