#ifndef __MV_FLOWFPS__
#define __MV_FLOWFPS__

#include "MVInterface.h"
#include "SimpleResize.h"
#include "yuy2planes.h"

class MVFlowFps : public GenericVideoFilter, public MVFilter {
private:

   MVClip mvClipB;
   MVClip mvClipF;
  	int numerator;
	int denominator;
  	int numeratorOld;
	int denominatorOld;
   double ml;
   bool isse;
   bool mmx;

   int time256;
   int nleftLast;
   int nrightLast;

   // fullframe vector mask
   BYTE *VXFullYB; //backward
   BYTE *VXFullUVB;
   BYTE *VYFullYB;
   BYTE *VYFullUVB;
   BYTE *VXFullYF; 
   BYTE *VXFullUVF;
   BYTE *VYFullYF;
   BYTE *VYFullUVF;

   // Small vector mask
   BYTE *VXSmallYB; 
   BYTE *VXSmallUVB;
   BYTE *VYSmallYB;
   BYTE *VYSmallUVB;
   BYTE *VXSmallYF; 
   BYTE *VXSmallUVF;
   BYTE *VYSmallYF;
   BYTE *VYSmallUVF;

   BYTE *MaskSmallB;
   BYTE *MaskFullYB;
   BYTE *MaskFullUVB;
   BYTE *MaskSmallF;
   BYTE *MaskFullYF;
   BYTE *MaskFullUVF;

   int nWidthUV;
   int nHeightUV;
	int	VPitchY, VPitchUV;

	int nBlkXP;
	 int nBlkYP;
	 int nWidthP;
	 int nHeightP;
	 int nWidthPUV;
	 int nHeightPUV; 

	int *LUTVB; // luckup
	int *LUTVF;


	int pel2PitchY, pel2HeightY, pel2PitchUV, pel2HeightUV, pel2OffsetY, pel2OffsetUV;

   BYTE * pel2PlaneYB; // big plane
   BYTE * pel2PlaneUB;
   BYTE * pel2PlaneVB;
   BYTE * pel2PlaneYF; // big plane
   BYTE * pel2PlaneUF;
   BYTE * pel2PlaneVF;
   
   SimpleResize *upsizer;
   SimpleResize *upsizerUV;
	void FlowInter(BYTE * pdst, int dst_pitch, const BYTE *prefB, const BYTE *prefF, int ref_pitch,  
			   BYTE *VXFullB, BYTE *VXFullF, BYTE *VYFullB, BYTE *VYFullF, BYTE *MaskB, BYTE *MaskF,
			   int VPitch, int width, int height, int time256);
	void Create_LUTV(int time256, int *LUTVB, int *LUTVF);

	YUY2Planes * SrcPlanes;
	YUY2Planes * RefPlanes;
	YUY2Planes * DstPlanes;

public:
	MVFlowFps(PClip _child, PClip _mvbw, PClip _mvfw, int _num, int _den, double _ml, int _nIdx,
                int nSCD1, int nSCD2, bool mmx, bool isse, IScriptEnvironment* env);
	~MVFlowFps();
	PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env);
};

#endif