// Pixels flow motion interpolation function to change FPS 
// with using second clip cropped by halfblock along diagonal (crop(4,4,-4,-4)) 
// Copyright(c)2005 A.G.Balakhnin aka Fizick

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#include "MVFlowFps2.h"
#include "CopyCode.h"
#include "MaskFun.h"


MVFlowFps2::MVFlowFps2(PClip _child, PClip _mvbw, PClip _mvfw, PClip _mvbw2, PClip _mvfw2,  
					   int _num, int _den, double _ml, int _nIdx, int _nIdx2,
                           int nSCD1, int nSCD2, bool _mmx, bool _isse, IScriptEnvironment* env) :
GenericVideoFilter(_child),
MVFilter(_mvbw, "MVFlowFps2", env),
mvClipB(_mvbw, nSCD1, nSCD2, env),
mvClipF(_mvfw, nSCD1, nSCD2, env),
mvClipB2(_mvbw2, nSCD1, nSCD2, env),
mvClipF2(_mvfw2, nSCD1, nSCD2, env)
{
	numerator = _num;
	denominator = _den;
	numeratorOld = vi.fps_numerator;
	denominatorOld = vi.fps_denominator;

	vi.fps_numerator = numerator;
	vi.fps_denominator = denominator;
	vi.num_frames = (int)(1 + __int64(vi.num_frames-1) * numerator*denominatorOld/(denominator*numeratorOld) );

   ml = _ml;
   nIdx = _nIdx;
   nIdx2 = _nIdx2; // how to use (or not use) second idx???
   mmx = _mmx;
   isse = _isse;

   nBlkXCropped = mvClipB2.GetBlkX();
   nBlkYCropped = mvClipB2.GetBlkY();

     mvCore->AddFrames(nIdx, MV_BUFFER_FRAMES, mvClipB.GetLevelCount(), nWidth, nHeight,
                        nPel, nBlkSize, nBlkSize, YUVPLANES, isse, yRatioUV);
     mvCore->AddFrames(nIdx, MV_BUFFER_FRAMES, mvClipF.GetLevelCount(), nWidth, nHeight,
                        nPel, nBlkSize, nBlkSize, YUVPLANES, isse, yRatioUV);

     mvCore->AddFrames(nIdx2, MV_BUFFER_FRAMES, mvClipB2.GetLevelCount(), nWidth, nHeight,
                        nPel, nBlkSize, nBlkSize, YUVPLANES, isse, yRatioUV);
     mvCore->AddFrames(nIdx2, MV_BUFFER_FRAMES, mvClipF2.GetLevelCount(), nWidth, nHeight,
                        nPel, nBlkSize, nBlkSize, YUVPLANES, isse, yRatioUV);

	 nHeightUV = nHeight/yRatioUV; // for YV12
	 nWidthUV = nWidth/2;
	 int nHPaddingUV = nHPadding/2;
	 int nVPaddingUV = nVPadding/yRatioUV;

		VPitchY = nWidth;
		VPitchUV= nWidthUV;

 	 VXFullYB = new BYTE [nHeight*VPitchY]; 
	 VXFullUVB = new BYTE [nHeightUV*VPitchUV];
 	 VYFullYB = new BYTE [nHeight*VPitchY];
	 VYFullUVB = new BYTE [nHeightUV*VPitchUV];

	 VXFullYF = new BYTE [nHeight*VPitchY]; 
	 VXFullUVF = new BYTE [nHeightUV*VPitchUV];
 	 VYFullYF = new BYTE [nHeight*VPitchY];
	 VYFullUVF = new BYTE [nHeightUV*VPitchUV];

  	 VXSmallYB = new BYTE [nBlkX*nBlkY];
  	 VYSmallYB = new BYTE [nBlkX*nBlkY];

  	 VXSmallYB2 = new BYTE [nBlkX*nBlkY];
  	 VYSmallYB2 = new BYTE [nBlkX*nBlkY];

  	 VXSmallYF = new BYTE [nBlkX*nBlkY];
  	 VYSmallYF = new BYTE [nBlkX*nBlkY];

  	 VXSmallYF2 = new BYTE [nBlkX*nBlkY];
  	 VYSmallYF2 = new BYTE [nBlkX*nBlkY];

  	 VXDoubledYB = new BYTE [nBlkX*nBlkY*4];
  	 VYDoubledYB = new BYTE [nBlkX*nBlkY*4];

  	 VXDoubledYB2 = new BYTE [nBlkX*nBlkY*4];
  	 VYDoubledYB2 = new BYTE [nBlkX*nBlkY*4];

  	 VXDoubledYF = new BYTE [nBlkX*nBlkY*4];
  	 VYDoubledYF = new BYTE [nBlkX*nBlkY*4];

  	 VXDoubledYF2 = new BYTE [nBlkX*nBlkY*4];
  	 VYDoubledYF2 = new BYTE [nBlkX*nBlkY*4];

  	 VXCombinedYF = new BYTE [nBlkX*nBlkY*4];
  	 VYCombinedYF = new BYTE [nBlkX*nBlkY*4];
	 VXCombinedUVF = new BYTE [nBlkX*nBlkY*4]; 
	 VYCombinedUVF = new BYTE [nBlkX*nBlkY*4]; 

  	 VXCombinedYB = new BYTE [nBlkX*nBlkY*4];
  	 VYCombinedYB = new BYTE [nBlkX*nBlkY*4];
	 VXCombinedUVB = new BYTE [nBlkX*nBlkY*4]; 
	 VYCombinedUVB = new BYTE [nBlkX*nBlkY*4]; 

	 MaskDoubledB = new BYTE [nBlkX*nBlkY*4]; 
	 MaskFullYB = new BYTE [nHeight*VPitchY]; 
	 MaskFullUVB = new BYTE [nHeightUV*VPitchUV]; 

	 MaskDoubledF = new BYTE [nBlkX*nBlkY*4]; 
	 MaskFullYF = new BYTE [nHeight*VPitchY]; 
	 MaskFullUVF = new BYTE [nHeightUV*VPitchUV]; 


	 int pel2WidthY = (nWidth + 2*nHPadding)*nPel; 
	 pel2HeightY = (nHeight + 2*nVPadding)*nPel;
	 int pel2WidthUV = (nWidthUV + 2*nHPaddingUV)*nPel;
	 pel2HeightUV = (nHeightUV + 2*nVPaddingUV)*nPel;
	pel2PitchY = (pel2WidthY + 15) & (~15);
   	pel2PitchUV = (pel2WidthUV + 15) & (~15);
    pel2OffsetY = pel2PitchY * nVPadding*nPel + nHPadding*nPel;
    pel2OffsetUV = pel2PitchUV * nVPaddingUV*nPel + nHPaddingUV*nPel;
	 if (nPel>1)
	 {
		 pel2PlaneYB = new BYTE [pel2PitchY*pel2HeightY];
		 pel2PlaneUB = new BYTE [pel2PitchUV*pel2HeightUV];
		 pel2PlaneVB = new BYTE [pel2PitchUV*pel2HeightUV];
		 pel2PlaneYF = new BYTE [pel2PitchY*pel2HeightY];
		 pel2PlaneUF = new BYTE [pel2PitchUV*pel2HeightUV];
		 pel2PlaneVF = new BYTE [pel2PitchUV*pel2HeightUV];
	 }

	 int CPUF_Resize = env->GetCPUFlags();
	 if (!isse) CPUF_Resize = (CPUF_Resize & !CPUF_INTEGER_SSE) & !CPUF_SSE2;

	 upsizer = new SimpleResize(nWidth, nHeight, nBlkX*2, nBlkY*2, CPUF_Resize); 
	 upsizerUV = new SimpleResize(nWidthUV, nHeightUV, nBlkX*2, nBlkY*2, CPUF_Resize); 

	 upsizer2 = new SimpleResize(nBlkX*2, nBlkY*2, nBlkX, nBlkY, CPUF_Resize); 

	 nleftLast = -1000;
	 nrightLast = -1000;

	 if ( (pixelType & VideoInfo::CS_YUY2) == VideoInfo::CS_YUY2 )
   {
		SrcPlanes =  new YUY2Planes(nWidth, nHeight);
		RefPlanes =  new YUY2Planes(nWidth, nHeight);
		DstPlanes =  new YUY2Planes(nWidth, nHeight);
   }
}

MVFlowFps2::~MVFlowFps2()
{
   if ( (pixelType & VideoInfo::CS_YUY2) == VideoInfo::CS_YUY2 )
   {
	delete SrcPlanes;
	delete RefPlanes;
	delete DstPlanes;
   }
	delete upsizer2;
	delete upsizer;
	delete upsizerUV;

	delete VXFullYB;
	delete VXFullUVB;
	delete VYFullYB;
	delete VYFullUVB;
	delete VXSmallYB;
	delete VYSmallYB;
	delete VXSmallYB2;
	delete VYSmallYB2;
	delete VXFullYF;
	delete VXFullUVF;
	delete VYFullYF;
	delete VYFullUVF;
	delete VXSmallYF;
	delete VYSmallYF;
	delete VXSmallYF2;
	delete VYSmallYF2;

	delete VXDoubledYF;
	delete VYDoubledYF;
	delete VXDoubledYF2;
	delete VYDoubledYF2;

	delete VXDoubledYB;
	delete VYDoubledYB;
	delete VXDoubledYB2;
	delete VYDoubledYB2;

	delete MaskDoubledB;
	delete MaskFullYB;
	delete MaskFullUVB;
	delete MaskDoubledF;
	delete MaskFullYF;
	delete MaskFullUVF;

	delete VXCombinedYB;
	delete VYCombinedYB;
	delete VXCombinedUVB;
	delete VYCombinedUVB;
	delete VXCombinedYF;
	delete VYCombinedYF;
	delete VXCombinedUVF;
	delete VYCombinedUVF;

	
	if (nPel>1)
	 {
		 delete pel2PlaneYB; 
		 delete pel2PlaneUB; 
		 delete pel2PlaneVB; 
		 delete pel2PlaneYF; 
		 delete pel2PlaneUF; 
		 delete pel2PlaneVF; 
	 }

}


void MVFlowFps2::FlowInter(BYTE * pdst, int dst_pitch, const BYTE *prefB, const BYTE *prefF, int ref_pitch,  
			   BYTE *VXFullB, BYTE *VXFullF, BYTE *VYFullB, BYTE *VYFullF, BYTE *MaskB, BYTE *MaskF,
			   int VPitch, int width, int height, int time256)
{
	if (nPel==1)
	{
		for (int h=0; h<height; h++)
		{
			for (int w=0; w<width; w++)
			{
				int vxF = ((VXFullF[w]-128)*time256)/256;
				int vyF = ((VYFullF[w]-128)*time256)/256;
				int dstF = prefF[vyF*ref_pitch + vxF + w]; 
				int vxB = ((VXFullB[w]-128)*(256-time256))/256;
				int vyB = ((VYFullB[w]-128)*(256-time256))/256;
				int dstB = prefB[vyB*ref_pitch + vxB + w]; 
				pdst[w] = ( ( (dstF*(255-MaskF[w]) + dstB*MaskF[w] + 255)>>8 )*(256-time256) + 
				            ( (dstB*(255-MaskB[w]) + dstF*MaskB[w] + 255)>>8 )*time256 )>>8;
			}
			pdst += dst_pitch;
			prefB += ref_pitch;
			prefF += ref_pitch;
			VXFullB += VPitch;
			VYFullB += VPitch;
			VXFullF += VPitch;
			VYFullF += VPitch;
			MaskB += VPitch;
			MaskF += VPitch;
		}
	}
	else if (nPel==2)
	{
		for (int h=0; h<height; h++)
		{
			for (int w=0; w<width; w++)
			{
				int vxF = ((VXFullF[w]-128)*time256)/256;
				int vyF = ((VYFullF[w]-128)*time256)/256;
				int dstF = prefF[vyF*ref_pitch + vxF + (w<<1)]; 
				int vxB = ((VXFullB[w]-128)*(256-time256))/256;
				int vyB = ((VYFullB[w]-128)*(256-time256))/256;
				int dstB = prefB[vyB*ref_pitch + vxB + (w<<1)]; 
				pdst[w] = ( ( (dstF*(255-MaskF[w]) + dstB*MaskF[w] + 255)>>8 )*(256-time256) + 
				            ( (dstB*(255-MaskB[w]) + dstF*MaskB[w] + 255)>>8 )*time256 )>>8;
			}
			pdst += dst_pitch;
			prefB += ref_pitch<<1;
			prefF += ref_pitch<<1;
			VXFullB += VPitch;
			VYFullB += VPitch;
			VXFullF += VPitch;
			VYFullF += VPitch;
			MaskB += VPitch;
			MaskF += VPitch;
		}
	}
}


void CombineShiftedMask(BYTE *VXDoubled, BYTE *VXDoubledShifted, BYTE *VXCombined, int nBlkX2, int nBlkY2)
{ // diagonal shift by halfblock, i.e. by 1 here
	for (int w=0; w<nBlkX2; w++)
		VXCombined[w] = VXDoubled[w];
	VXDoubled += nBlkX2;
	VXCombined += nBlkX2;
	for (int h=1; h<nBlkY2-1; h++)
	{
		VXCombined[0] = VXDoubled[0];
		for (int w=1; w<nBlkX2-1; w++)
		{
			VXCombined[w] = (VXDoubled[w] + VXDoubledShifted[w-1] )>>1;
		}
		VXCombined[nBlkX2-1] = VXDoubled[nBlkX2-1];
		VXDoubled += nBlkX2;
		VXDoubledShifted += nBlkX2;
		VXCombined += nBlkX2;
	}
	for (int w=0; w<nBlkX2; w++)
		VXCombined[w] = VXDoubled[w];
	VXDoubled += nBlkX2;
	VXCombined += nBlkX2;
}

void FillCroppedMaskPad(BYTE *VSmallY2, int widthCropped, int heightCropped, int width, int height)
{
	// we use cropped second clip
	// it is cropped in all sides.
	// but we store it's vector mask in array with non-cropped sizes
	// here we pad right and bottom part to zero vector
	// zero vector value is 128
	for (int h=0; h<heightCropped; h++)
	{
		for (int w=widthCropped; w<width; w++)
			VSmallY2[w] = 128;
		VSmallY2 += width;
	}
	
	for (int h=heightCropped; h<height; h++)
	{
		for (int w=0; w<width; w++)
			VSmallY2[w] = 128;
		VSmallY2 += width;
	}

}


//-------------------------------------------------------------------------
PVideoFrame __stdcall MVFlowFps2::GetFrame(int n, IScriptEnvironment* env)
{
	int nleft = (__int64) (__int64(n)* __int64(denominator)* __int64(numeratorOld))/( __int64(numerator)*__int64(denominatorOld)); 
	// intermediate product may be very large! Now I know how to multiply int64 
	time256 = int( (double(n)*double(denominator)*double(numeratorOld)/double(numerator)/double(denominatorOld) - nleft)*256 + 0.5);

	PVideoFrame	src	= child->GetFrame(nleft, env);
   PVideoFrame dst;
   BYTE *pDst[3];
	const BYTE *pRef[3], *pSrc[3];
    int nDstPitches[3], nRefPitches[3], nSrcPitches[3];
	unsigned char *pDstYUY2;
	int nDstPitchYUY2;


	int off = mvClipB.GetDeltaFrame(); // integer offset of reference frame

	int nright = nleft+off; // really off must be = 1

	PVideoFrame ref = child->GetFrame(nright, env);//  right frame for  compensation

	if (time256 ==0)
		return src; // simply left
	else if (time256==256)
		return ref; // simply right

	mvClipB.Update(nleft, env);// backward from next to current
	mvClipF.Update(nright, env);// forward from current to next

	mvClipB2.Update(nleft, env);// backward from next to current
	mvClipF2.Update(nright, env);// forward from current to next


   if ( mvClipB.IsUsable() && mvClipF.IsUsable() && mvClipB2.IsUsable() && mvClipF2.IsUsable() )
   {
		dst = env->NewVideoFrame(vi);

		MVFrames *pFrames = mvCore->GetFrames(nIdx);

         MVGroupOfFrames *pRefGOFF = pFrames->GetFrame(nleft); // forward ref
         MVGroupOfFrames *pRefGOFB = pFrames->GetFrame(nright); // backward ref

		if ( (pixelType & VideoInfo::CS_YUY2) == VideoInfo::CS_YUY2 )
		{
			const unsigned char *pSrcYUY2 = src->GetReadPtr();
			int nSrcPitchYUY2 = src->GetPitch();
			pSrc[0] = SrcPlanes->GetPtr();
			pSrc[1] = SrcPlanes->GetPtrU();
			pSrc[2] = SrcPlanes->GetPtrV();
			nSrcPitches[0]  = SrcPlanes->GetPitch();
			nSrcPitches[1]  = SrcPlanes->GetPitchUV();
			nSrcPitches[2]  = SrcPlanes->GetPitchUV();
			YUY2ToPlanes(pSrcYUY2, nSrcPitchYUY2, nWidth, nHeight, 
				pSrc[0], nSrcPitches[0], pSrc[1], pSrc[2], nSrcPitches[1], isse);

			const unsigned char *pRefYUY2 = ref->GetReadPtr();
			int nRefPitchYUY2 = ref->GetPitch();
			pRef[0] = RefPlanes->GetPtr();
			pRef[1] = RefPlanes->GetPtrU();
			pRef[2] = RefPlanes->GetPtrV();
			nRefPitches[0]  = RefPlanes->GetPitch();
			nRefPitches[1]  = RefPlanes->GetPitchUV();
			nRefPitches[2]  = RefPlanes->GetPitchUV();
			YUY2ToPlanes(pRefYUY2, nRefPitchYUY2, nWidth, nHeight, 
				pRef[0], nRefPitches[0], pRef[1], pRef[2], nRefPitches[1], isse);

			pDstYUY2 = dst->GetWritePtr();
			nDstPitchYUY2 = dst->GetPitch();
			pDst[0] = DstPlanes->GetPtr();
			pDst[1] = DstPlanes->GetPtrU();
			pDst[2] = DstPlanes->GetPtrV();
			nDstPitches[0]  = DstPlanes->GetPitch();
			nDstPitches[1]  = DstPlanes->GetPitchUV();
			nDstPitches[2]  = DstPlanes->GetPitchUV();
			YUY2ToPlanes(pDstYUY2, nDstPitchYUY2, nWidth, nHeight, 
				pDst[0], nDstPitches[0], pDst[1], pDst[2], nDstPitches[1], isse);
		}
		else
		{
 
         pDst[0] = YWPLAN(dst);
         pDst[1] = UWPLAN(dst);
         pDst[2] = VWPLAN(dst);
         nDstPitches[0] = YPITCH(dst);
         nDstPitches[1] = UPITCH(dst);
         nDstPitches[2] = VPITCH(dst);

         pRef[0] = YRPLAN(ref);
         pRef[1] = URPLAN(ref);
         pRef[2] = VRPLAN(ref);
         nRefPitches[0] = YPITCH(ref);
         nRefPitches[1] = UPITCH(ref);
         nRefPitches[2] = VPITCH(ref);

         pSrc[0] = YRPLAN(src);
         pSrc[1] = URPLAN(src);
         pSrc[2] = VRPLAN(src);
         nSrcPitches[0] = YPITCH(src);
         nSrcPitches[1] = UPITCH(src);
         nSrcPitches[2] = VPITCH(src);
		}

         pRefGOFF->SetPlane(pSrc[0], nSrcPitches[0], YPLANE);
         pRefGOFF->SetPlane(pSrc[1], nSrcPitches[1], UPLANE);
         pRefGOFF->SetPlane(pSrc[2], nSrcPitches[2], VPLANE);
         pRefGOFF->Pad(YUVPLANES);
         pRefGOFF->Refine(YUVPLANES);

         pRefGOFB->SetPlane(pRef[0], nRefPitches[0], YPLANE);
         pRefGOFB->SetPlane(pRef[1], nRefPitches[1], UPLANE);
         pRefGOFB->SetPlane(pRef[2], nRefPitches[2], VPLANE);
         pRefGOFB->Pad(YUVPLANES);
         pRefGOFB->Refine(YUVPLANES);

         MVPlane *pPlanesB[3];
         MVPlane *pPlanesF[3];

         pPlanesB[0] = pRefGOFB->GetFrame(0)->GetPlane(YPLANE);
         pPlanesB[1] = pRefGOFB->GetFrame(0)->GetPlane(UPLANE);
         pPlanesB[2] = pRefGOFB->GetFrame(0)->GetPlane(VPLANE);

         pPlanesF[0] = pRefGOFF->GetFrame(0)->GetPlane(YPLANE);
         pPlanesF[1] = pRefGOFF->GetFrame(0)->GetPlane(UPLANE);
         pPlanesF[2] = pRefGOFF->GetFrame(0)->GetPlane(VPLANE);


		 if (nPel==2)
		 {
			 // merge refined planes to big single plane
			 if (nright != nrightLast)
			 {
			 Merge4PlanesToBig(pel2PlaneYB, pel2PitchY, pPlanesB[0]->GetAbsolutePointer(0,0), 
				 pPlanesB[0]->GetAbsolutePointer(1,0), pPlanesB[0]->GetAbsolutePointer(0,1),
				 pPlanesB[0]->GetAbsolutePointer(1,1), pPlanesB[0]->GetExtendedWidth(),
				 pPlanesB[0]->GetExtendedHeight(), pPlanesB[0]->GetPitch(), isse);
			 Merge4PlanesToBig(pel2PlaneUB, pel2PitchUV, pPlanesB[1]->GetAbsolutePointer(0,0), 
				 pPlanesB[1]->GetAbsolutePointer(1,0), pPlanesB[1]->GetAbsolutePointer(0,1),
				 pPlanesB[1]->GetAbsolutePointer(1,1), pPlanesB[1]->GetExtendedWidth(),
				 pPlanesB[1]->GetExtendedHeight(), pPlanesB[1]->GetPitch(), isse);
			 Merge4PlanesToBig(pel2PlaneVB, pel2PitchUV, pPlanesB[2]->GetAbsolutePointer(0,0), 
				 pPlanesB[2]->GetAbsolutePointer(1,0), pPlanesB[2]->GetAbsolutePointer(0,1),
				 pPlanesB[2]->GetAbsolutePointer(1,1), pPlanesB[2]->GetExtendedWidth(),
				 pPlanesB[2]->GetExtendedHeight(), pPlanesB[2]->GetPitch(), isse);
			 }

			 if(nleft != nleftLast)
			 {
			 Merge4PlanesToBig(pel2PlaneYF, pel2PitchY, pPlanesF[0]->GetAbsolutePointer(0,0), 
				 pPlanesF[0]->GetAbsolutePointer(1,0), pPlanesF[0]->GetAbsolutePointer(0,1),
				 pPlanesF[0]->GetAbsolutePointer(1,1), pPlanesF[0]->GetExtendedWidth(),
				 pPlanesF[0]->GetExtendedHeight(), pPlanesF[0]->GetPitch(), isse);
			 Merge4PlanesToBig(pel2PlaneUF, pel2PitchUV, pPlanesF[1]->GetAbsolutePointer(0,0), 
				 pPlanesF[1]->GetAbsolutePointer(1,0), pPlanesF[1]->GetAbsolutePointer(0,1),
				 pPlanesF[1]->GetAbsolutePointer(1,1), pPlanesF[1]->GetExtendedWidth(),
				 pPlanesF[1]->GetExtendedHeight(), pPlanesF[1]->GetPitch(), isse);
			 Merge4PlanesToBig(pel2PlaneVF, pel2PitchUV, pPlanesF[2]->GetAbsolutePointer(0,0), 
				 pPlanesF[2]->GetAbsolutePointer(1,0), pPlanesF[2]->GetAbsolutePointer(0,1),
				 pPlanesF[2]->GetAbsolutePointer(1,1), pPlanesF[2]->GetExtendedWidth(),
				 pPlanesF[2]->GetExtendedHeight(), pPlanesF[2]->GetPitch(), isse);
			 }

		 }


		int dummyplane = PLANAR_Y; // use luma plane resizer code for all planes if we resize from luma small mask

//		 if (nright != nrightLast)
		 {
			// make  vector vx and vy small masks
			// 1. ATTENTION: vectors are assumed SHORT (|vx|, |vy| < 127) !
			// 2. they will be zeroed if not
			// 3. added 128 to all values
			MakeVectorSmallMasks(mvClipB, nBlkX, nBlkY, VXSmallYB, nBlkX, VYSmallYB, nBlkX);
			// upsize (bilinear interpolate) vector masks to doubled size
			upsizer2->SimpleResizeDo(VXDoubledYB, nBlkX*2, nBlkY*2, nBlkX*2, VXSmallYB, nBlkX, nBlkX, dummyplane);
			upsizer2->SimpleResizeDo(VYDoubledYB, nBlkX*2, nBlkY*2, nBlkX*2, VYSmallYB, nBlkX, nBlkX, dummyplane);
			//second - shifted clip
			MakeVectorSmallMasks(mvClipB2, nBlkXCropped, nBlkYCropped, VXSmallYB2, nBlkX, VYSmallYB2, nBlkX);
			FillCroppedMaskPad(VXSmallYB2, nBlkXCropped, nBlkYCropped, nBlkX, nBlkY);
			FillCroppedMaskPad(VYSmallYB2, nBlkXCropped, nBlkYCropped, nBlkX, nBlkY);
			// upsize (bilinear interpolate) vector masks to doubled size
			upsizer2->SimpleResizeDo(VXDoubledYB2, nBlkX*2, nBlkY*2, nBlkX*2, VXSmallYB2, nBlkX, nBlkX, dummyplane);
			upsizer2->SimpleResizeDo(VYDoubledYB2, nBlkX*2, nBlkY*2, nBlkX*2, VYSmallYB2, nBlkX, nBlkX, dummyplane);

			// combine non-shifted and shifted doubled mask to form combined average mask
			CombineShiftedMask(VXDoubledYB, VXDoubledYB2, VXCombinedYB, nBlkX*2, nBlkY*2);
			VectorSmallMaskYToHalfUV(VXCombinedYB, nBlkX*2, nBlkY*2, VXCombinedUVB, 2);
			CombineShiftedMask(VYDoubledYB, VYDoubledYB2, VYCombinedYB, nBlkX*2, nBlkY*2);
			VectorSmallMaskYToHalfUV(VYCombinedYB, nBlkX*2, nBlkY*2, VYCombinedUVB, yRatioUV);
			upsizer->SimpleResizeDo(VXFullYB, nWidth, nHeight, VPitchY, VXCombinedYB, nBlkX*2, nBlkX*2, dummyplane);
			upsizer->SimpleResizeDo(VYFullYB, nWidth, nHeight, VPitchY, VYCombinedYB, nBlkX*2, nBlkX*2, dummyplane);
			upsizerUV->SimpleResizeDo(VXFullUVB, nWidthUV, nHeightUV, VPitchUV, VXCombinedUVB, nBlkX*2, nBlkX*2, dummyplane);
			upsizerUV->SimpleResizeDo(VYFullUVB, nWidthUV, nHeightUV, VPitchUV, VYCombinedUVB, nBlkX*2, nBlkX*2, dummyplane);
		 }

		// analyse vectors field to detect occlusion
		double occNormB = 2*(256-time256)/(256*ml);
//		MakeVectorOcclusionMask(mvClipB, nBlkX, nBlkY, occNormB, 1.0, nPel, MaskSmallB);
		VectorMasksToOcclusionMask(VXCombinedYB, VYCombinedYB, nBlkX*2, nBlkY*2, occNormB, 1.0, nPel, MaskDoubledB);
		upsizer->SimpleResizeDo(MaskFullYB, nWidth, nHeight, VPitchY, MaskDoubledB, nBlkX*2, nBlkX*2, dummyplane);
		upsizerUV->SimpleResizeDo(MaskFullUVB, nWidthUV, nHeightUV, VPitchUV, MaskDoubledB, nBlkX*2, nBlkX*2, dummyplane);

		 nrightLast = nright;


//		 if(nleft != nleftLast)
		 {
			// make  vector vx and vy small masks
			// 1. ATTENTION: vectors are assumed SHORT (|vx|, |vy| < 127) !
			// 2. they will be zeroed if not
			// 3. added 128 to all values
			MakeVectorSmallMasks(mvClipF, nBlkX, nBlkY, VXSmallYF, nBlkX, VYSmallYF, nBlkX);
			// upsize (bilinear interpolate) vector masks to doubled size
			upsizer2->SimpleResizeDo(VXDoubledYF, nBlkX*2, nBlkY*2, nBlkX*2, VXSmallYF, nBlkX, nBlkX, dummyplane);
			upsizer2->SimpleResizeDo(VYDoubledYF, nBlkX*2, nBlkY*2, nBlkX*2, VYSmallYF, nBlkX, nBlkX, dummyplane);
			// second - shifted clip
			MakeVectorSmallMasks(mvClipF2, nBlkXCropped, nBlkYCropped, VXSmallYF2, nBlkX, VYSmallYF2, nBlkX);
			FillCroppedMaskPad(VXSmallYF2, nBlkXCropped, nBlkYCropped, nBlkX, nBlkY);
			FillCroppedMaskPad(VYSmallYF2, nBlkXCropped, nBlkYCropped, nBlkX, nBlkY);
			// upsize (bilinear interpolate) vector masks to fullframe size
			upsizer2->SimpleResizeDo(VXDoubledYF2, nBlkX*2, nBlkY*2, nBlkX*2, VXSmallYF2, nBlkX, nBlkX, dummyplane);
			upsizer2->SimpleResizeDo(VYDoubledYF2, nBlkX*2, nBlkY*2, nBlkX*2, VYSmallYF2, nBlkX, nBlkX, dummyplane);

			// combine non-shifted and shifted doubled mask to form combined average mask
			CombineShiftedMask(VXDoubledYF, VXDoubledYF2, VXCombinedYF, nBlkX*2, nBlkY*2);
			VectorSmallMaskYToHalfUV(VXCombinedYF, nBlkX*2, nBlkY*2, VXCombinedUVF, 2);
			CombineShiftedMask(VYDoubledYF, VYDoubledYF2, VYCombinedYF, nBlkX*2, nBlkY*2);
			VectorSmallMaskYToHalfUV(VYCombinedYF, nBlkX*2, nBlkY*2, VYCombinedUVF, yRatioUV);
			upsizer->SimpleResizeDo(VXFullYF, nWidth, nHeight, VPitchY, VXCombinedYF, nBlkX*2, nBlkX*2, dummyplane);
			upsizer->SimpleResizeDo(VYFullYF, nWidth, nHeight, VPitchY, VYCombinedYF, nBlkX*2, nBlkX*2, dummyplane);
			upsizerUV->SimpleResizeDo(VXFullUVF, nWidthUV, nHeightUV, VPitchUV, VXCombinedUVF, nBlkX*2, nBlkX*2, dummyplane);
			upsizerUV->SimpleResizeDo(VYFullUVF, nWidthUV, nHeightUV, VPitchUV, VYCombinedUVF, nBlkX*2, nBlkX*2, dummyplane);

		 }
		// analyse vectors field to detect occlusion
		double occNormF = 2*time256/(256*ml);
		VectorMasksToOcclusionMask(VXCombinedYF, VYCombinedYF, nBlkX*2, nBlkY*2, occNormF, 1.0, nPel, MaskDoubledF);
		upsizer->SimpleResizeDo(MaskFullYF, nWidth, nHeight, VPitchY, MaskDoubledF, nBlkX*2, nBlkX*2, dummyplane);
		upsizerUV->SimpleResizeDo(MaskFullUVF, nWidthUV, nHeightUV, VPitchUV, MaskDoubledF, nBlkX*2, nBlkX*2, dummyplane);

		 nleftLast = nleft;

		  if (nPel==2)
		  {
			FlowInter(pDst[0], nDstPitches[0], pel2PlaneYB + pel2OffsetY, pel2PlaneYF + pel2OffsetY, pel2PitchY, 
				VXFullYB, VXFullYF, VYFullYB, VYFullYF, MaskFullYB, MaskFullYF, VPitchY, 
				nWidth, nHeight, time256);
			FlowInter(pDst[1], nDstPitches[1], pel2PlaneUB + pel2OffsetUV, pel2PlaneUF + pel2OffsetUV, pel2PitchUV,
				VXFullUVB, VXFullUVF, VYFullUVB, VYFullUVF, MaskFullUVB, MaskFullUVF, VPitchUV, 
				nWidthUV, nHeightUV, time256);
			FlowInter(pDst[2], nDstPitches[2], pel2PlaneVB + pel2OffsetUV, pel2PlaneVF + pel2OffsetUV, pel2PitchUV, 
				VXFullUVB, VXFullUVF, VYFullUVB, VYFullUVF, MaskFullUVB, MaskFullUVF, VPitchUV, 
				nWidthUV, nHeightUV, time256);

		  }
		  else if (nPel==1)
		  {
			FlowInter(pDst[0], nDstPitches[0], pPlanesB[0]->GetPointer(0,0), pPlanesF[0]->GetPointer(0,0), pPlanesB[0]->GetPitch(), 
				VXFullYB, VXFullYF, VYFullYB, VYFullYF, MaskFullYB, MaskFullYF, VPitchY, 
				nWidth, nHeight, time256);
			FlowInter(pDst[1], nDstPitches[1], pPlanesB[1]->GetPointer(0,0), pPlanesF[1]->GetPointer(0,0), pPlanesB[1]->GetPitch(), 
				VXFullUVB, VXFullUVF, VYFullUVB, VYFullUVF, MaskFullUVB, MaskFullUVF, VPitchUV, 
				nWidthUV, nHeightUV, time256);
			FlowInter(pDst[2], nDstPitches[2], pPlanesB[2]->GetPointer(0,0), pPlanesF[2]->GetPointer(0,0), pPlanesB[2]->GetPitch(), 
				VXFullUVB, VXFullUVF, VYFullUVB, VYFullUVF, MaskFullUVB, MaskFullUVF, VPitchUV, 
				nWidthUV, nHeightUV, time256);
		  }

		if ( (pixelType & VideoInfo::CS_YUY2) == VideoInfo::CS_YUY2 )
		{
			YUY2FromPlanes(pDstYUY2, nDstPitchYUY2, nWidth, nHeight,
								  pDst[0], nDstPitches[0], pDst[1], pDst[2], nDstPitches[1], isse);
		}
		return dst;		 
   }
   else 
   {
	   return src;
   }

}