#ifndef __MV_FRAME_H__
#define __MV_FRAME_H__

#include "MVInterface.h"

#define MOTION_DELTA_FRAME_BUFFER 5

class MVPlane {
   Uint8 **pPlane;
   int nWidth;
   int nHeight;
   int nExtendedWidth;
   int nExtendedHeight;
   int nPitch;
   int nHPadding;
   int nVPadding;
   int nOffsetPadding;

   int nPel;

   bool isse;

   bool isPadded;
   bool isRefined;
   bool isFilled;

public :

   MVPlane(int _nWidth, int _nHeight, int _nPel, int _nHPad, int _nVPad, bool _isse);
   ~MVPlane();

   void ChangePlane(const Uint8 *pNewPlane, int nNewPitch);
   void Pad();
   void Refine();
   void ReduceTo(MVPlane *pReducedPlane);
   void WritePlane(FILE *pFile);

   inline const Uint8 *GetAbsolutePointer(int nX, int nY)
   {
      if ( nPel == 1 )
         return pPlane[0] + nX + nY * nPitch;

      int idx = (nX&1) | ((nY&1)<<1);

      nX >>= 1;
      nY >>= 1;

      return pPlane[idx] + nX + nY * nPitch;
   }

   inline const Uint8 *GetPointer(int nX, int nY)
   {
      return GetAbsolutePointer(nX + nHPadding * nPel, nY + nVPadding * nPel);
   }

   inline const Uint8 *GetAbsolutePelPointer(int nX, int nY)
   {  return pPlane[0] + nX + nY * nPitch; }

   inline int GetPitch() { return nPitch; }
   inline int GetWidth() { return nWidth; }
   inline int GetHeight() { return nHeight; }
   inline int GetExtendedWidth() { return nExtendedWidth; }
   inline int GetExtendedHeight() { return nExtendedHeight; }
   inline int GetHPadding() { return nHPadding; }
   inline int GetVPadding() { return nVPadding; }
   inline void ResetState() { isRefined = isFilled = isPadded = false; }

};

class MVFrame {

   MVPlane *pYPlane;
   MVPlane *pUPlane;
   MVPlane *pVPlane;

   int nMode;
   bool isse;

public:
   MVFrame(int nWidth, int nHeight, int nPel, int nHPad, int nVPad, int _nMode, bool _isse);
   ~MVFrame();

   void ChangePlane(const Uint8 *pNewSrc, int nNewPitch, MVPlaneSet _nMode);
   void Refine(MVPlaneSet _nMode);
   void Pad(MVPlaneSet _nMode);
   void ReduceTo(MVFrame *pFrame);
   void ResetState();
   void WriteFrame(FILE *pFile);

   inline MVPlane *GetPlane(MVPlaneSet _nMode)
   {
      if ( nMode & _nMode & YPLANE )
         return pYPlane;

      if ( nMode & _nMode & UPLANE )
         return pUPlane;

      if ( nMode & _nMode & VPLANE )
         return pVPlane;

      return 0;
   }

   inline int GetMode() { return nMode; }

};

class MVGroupOfFrames {

   int nLevelCount;
   MVFrame **pFrames;

   int nFrameIdx;
   int nRefCount;

public :

   MVGroupOfFrames(int _nLevelCount, int nWidth, int nHeight, int nPel, int nHPad, int nVPad, int nMode, bool isse);
   ~MVGroupOfFrames();

   MVFrame *GetFrame(int nLevel);
   void SetPlane(const Uint8 *pNewSrc, int nNewPitch, MVPlaneSet nMode);
   void SetFrameIdx(int _nFrameIdx);
   void Refine(MVPlaneSet nMode);
   void Pad(MVPlaneSet nMode);
   void Reduce();
   void ResetState();

   inline int GetFrameIdx() { return nFrameIdx; }
   inline int GetRefCount() { return nRefCount; }
   inline void IncRefCount() { nRefCount++; }
};

class MVFrames {

   MVGroupOfFrames **pGroupsOfFrames;
   int nNbFrames;
   int nIdx;

public:

   MVFrames(int _nIdx, int _nNbFrames, int nLevelCount, int nWidth, int nHeight, int nPel, int nHPad, int nVPad, int nMode, bool isse);
   ~MVFrames();

   MVGroupOfFrames *GetNewFrame(int nFrameIdx);
   MVGroupOfFrames *GetFrame(int nFrameIdx);
   inline int GetIdx() { return nIdx; }

};

class MVFramesList {
   MVFrames *pMVFrames;
   MVFramesList *pNext;

public :

   MVFramesList(MVFramesList *_pNext, int nIdx, int nNbFrames, int nLevelCount, int nWidth, int nHeight, int nPel, int nHPad, int nVPad, int nMode, bool isse);
   MVFramesList();
   ~MVFramesList();

   MVFrames *GetFrames(int _nIdx);
};

#endif
