#include "MVIncrease.h"

MVIncrease::MVIncrease(PClip _child, PClip vectors, int _vertical, int _horizontal, bool _sc, int _nIdx,
                       int nSCD1, int nSCD2, bool mmx, bool isse, IScriptEnvironment* env) :
GenericVideoFilter(_child),
mvClip(vectors, nSCD1, nSCD2, env),
MVFilter(vectors, "MVIncrease", env)
{
	if (!vi.IsYV12())
      env->ThrowError("MVIncrease : Color format must be YV12");

   nIdx = _nIdx;
   vertical = _vertical;
   horizontal = _horizontal;
   scBehavior = _sc;
   nBlkSize2 = nBlkSize / 2;

   if (( vertical < 1 ) || ( vertical > 4 ))
      env->ThrowError("MVIncrease : Vertical can only be 1 or 2");
   if (( horizontal < 1 ) || ( horizontal > 4 ))
      env->ThrowError("MVIncrease : Horizontal can only be 1 or 2");

#ifndef DYNAMIC_COMPILE
   if ( isse )
   {
      if ( nBlkSize == 4 )
      {
         if (( vertical == 2 ) && ( horizontal == 2 ))
         {
            BLITLUMA = Copy8_mmx;
            BLITCHROMA = Copy4_mmx;
         }
         else if (( vertical == 2 ) && ( horizontal == 1 ))
         {
            BLITLUMA = Copy_mmx<8, 4>;
            BLITCHROMA = Copy_mmx<4, 2>;
         }
         else if (( vertical == 1 ) && ( horizontal == 2 ))
         {
            BLITLUMA = Copy_mmx<4, 8>;
            BLITCHROMA = Copy_mmx<2, 4>;
         }
      }
      else if ( nBlkSize == 8 )
      {
         if (( vertical == 2 ) && ( horizontal == 2 ))
         {
            BLITLUMA = Copy16_mmx;
            BLITCHROMA = Copy8_mmx;
         }
         else if (( vertical == 2 ) && ( horizontal == 1 ))
         {
            BLITLUMA = Copy_mmx<16, 8>;
            BLITCHROMA = Copy_mmx<8, 4>;
         }
         else if (( vertical == 1 ) && ( horizontal == 2 ))
         {
            BLITLUMA = Copy_mmx<8, 16>;
            BLITCHROMA = Copy_mmx<4, 8>;
         }
      }
      else if ( nBlkSize == 16 )
      {
         if (( vertical == 2 ) && ( horizontal == 2 ))
         {
            BLITLUMA = Copy_mmx<32, 32>;
            BLITCHROMA = Copy16_mmx;
         }
         else if (( vertical == 2 ) && ( horizontal == 1 ))
         {
            BLITLUMA = Copy_mmx<32, 16>;
            BLITCHROMA = Copy_mmx<16, 8>;
         }
         else if (( vertical == 1 ) && ( horizontal == 2 ))
         {
            BLITLUMA = Copy_mmx<16, 32>;
            BLITCHROMA = Copy_mmx<8, 16>;
         }
      }
   }
   else
   {
      if ( nBlkSize == 4 )
      {
         if (( vertical == 2 ) && ( horizontal == 2 ))
         {
            BLITLUMA = Copy_C<8, 8>;
            BLITCHROMA = Copy_C<4, 4>;
         }
         else if (( vertical == 2 ) && ( horizontal == 1 ))
         {
            BLITLUMA = Copy_C<8, 4>;
            BLITCHROMA = Copy_C<4, 2>;
         }
         else if (( vertical == 1 ) && ( horizontal == 2 ))
         {
            BLITLUMA = Copy_C<4, 8>;
            BLITCHROMA = Copy_C<2, 4>;
         }
      }
      else if ( nBlkSize == 8 )
      {
         if (( vertical == 2 ) && ( horizontal == 2 ))
         {
            BLITLUMA = Copy_C<16, 16>;
            BLITCHROMA = Copy_C<8, 8>;
         }
         else if (( vertical == 2 ) && ( horizontal == 1 ))
         {
            BLITLUMA = Copy_C<16, 8>;
            BLITCHROMA = Copy_C<8, 4>;
         }
         else if (( vertical == 1 ) && ( horizontal == 2 ))
         {
            BLITLUMA = Copy_C<8, 16>;
            BLITCHROMA = Copy_C<4, 8>;
         }
      }
      else if ( nBlkSize == 16 )
      {
         if (( vertical == 2 ) && ( horizontal == 2 ))
         {
            BLITLUMA = Copy_C<32, 32>;
            BLITCHROMA = Copy_C<16, 16>;
         }
         else if (( vertical == 2 ) && ( horizontal == 1 ))
         {
            BLITLUMA = Copy_C<32, 16>;
            BLITCHROMA = Copy_C<16, 8>;
         }
         else if (( vertical == 1 ) && ( horizontal == 2 ))
         {
            BLITLUMA = Copy_C<16, 32>;
            BLITCHROMA = Copy_C<8, 16>;
         }
      }
   }

#else
   
   copyLuma = new SWCopy(nBlkSize * horizontal, nBlkSize * vertical);
   copyChroma = new SWCopy(nBlkSize2 * horizontal, nBlkSize2 * vertical);

#endif
   
   

   mvCore->AddFrames(nIdx, MV_BUFFER_FRAMES, 1, vi.width, vi.height,
                     nPel, nBlkSize * horizontal, nBlkSize * vertical, YUVPLANES, isse, yRatioUV);
}

MVIncrease::~MVIncrease()
{

#ifdef DYNAMIC_COMPILE
   delete copyLuma;
   delete copyChroma;
#endif

}

PVideoFrame __stdcall MVIncrease::GetFrame(int n, IScriptEnvironment *env)
{
	PVideoFrame	src	= child->GetFrame(n, env);
   PVideoFrame dst;

   mvClip.Update(n, env);

   int off = ( mvClip.IsBackward() ) ? 1 : -1;
   off *= mvClip.GetDeltaFrame();


   if ( mvClip.IsUsable() )
   {
      if (( vertical == 1 ) && ( horizontal == 1 ))
         return src;

      dst = env->NewVideoFrame(vi);
      PVideoFrame ref = child->GetFrame(n + off, env);
      MVFrames *pFrames = mvCore->GetFrames(nIdx);
      MVGroupOfFrames *pRefGOF = pFrames->GetFrame(n + off);

      PROFILE_START(MOTION_PROFILE_INTERPOLATION);

      pRefGOF->SetPlane(YRPLAN(ref), YPITCH(ref), YPLANE);
      pRefGOF->SetPlane(URPLAN(ref), UPITCH(ref), UPLANE);
      pRefGOF->SetPlane(VRPLAN(ref), VPITCH(ref), VPLANE);
      pRefGOF->Pad(YUVPLANES);
      pRefGOF->Refine(YUVPLANES);

      PROFILE_STOP(MOTION_PROFILE_INTERPOLATION);

      Uint8 *pDst[3];
      int pPitches[3];
      MVPlane *pPlanes[3];

      pDst[0] = YWPLAN(dst);
      pDst[1] = UWPLAN(dst);
      pDst[2] = VWPLAN(dst);
      pPitches[0] = YPITCH(dst);
      pPitches[1] = UPITCH(dst);
      pPitches[2] = VPITCH(dst);

      pPlanes[0] = pRefGOF->GetFrame(0)->GetPlane(YPLANE);
      pPlanes[1] = pRefGOF->GetFrame(0)->GetPlane(UPLANE);
      pPlanes[2] = pRefGOF->GetFrame(0)->GetPlane(VPLANE);

      PROFILE_START(MOTION_PROFILE_COMPENSATION);

      for ( int k = 0; k < mvClip.GetBlkCount(); k++ )
      {
         const FakeBlockData &block = mvClip.GetBlock(0, k);
#ifdef DYNAMIC_COMPILE
         copyLuma->Call(pDst[0], pPitches[0],
            pPlanes[0]->GetPointer((block.GetX() * nPel + block.GetMV().x) * horizontal,
                                   (block.GetY() * nPel + block.GetMV().y) * vertical), 
            pPlanes[0]->GetPitch());

         copyChroma->Call(pDst[1], pPitches[1],
            pPlanes[1]->GetPointer(((block.GetX() * nPel + block.GetMV().x) * horizontal) >> 1,
                                   ((block.GetY() * nPel + block.GetMV().y) * vertical) >> 1), 
            pPlanes[1]->GetPitch());

         copyChroma->Call(pDst[2], pPitches[2],
            pPlanes[2]->GetPointer(((block.GetX() * nPel + block.GetMV().x) * horizontal) >> 1,
                                   ((block.GetY() * nPel + block.GetMV().y) * vertical) >> 1), 
            pPlanes[2]->GetPitch());
#else
         // luma
         BLITLUMA(pDst[0], pPitches[0],
            pPlanes[0]->GetPointer((block.GetX() * nPel + block.GetMV().x) * horizontal,
                                   (block.GetY() * nPel + block.GetMV().y) * vertical), 
            pPlanes[0]->GetPitch());

         // chroma u
         BLITCHROMA(pDst[1], pPitches[1],
            pPlanes[1]->GetPointer(((block.GetX() * nPel + block.GetMV().x) * horizontal) >> 1,
                                   ((block.GetY() * nPel + block.GetMV().y) * vertical) >> 1), 
            pPlanes[1]->GetPitch());

         // chroma v
         BLITCHROMA(pDst[2], pPitches[2],
            pPlanes[2]->GetPointer(((block.GetX() * nPel + block.GetMV().x) * horizontal) >> 1,
                                   ((block.GetY() * nPel + block.GetMV().y) * vertical) >> 1), 
            pPlanes[2]->GetPitch());
#endif

         // update pDsts
         pDst[0] += nBlkSize * horizontal;
         pDst[1] += nBlkSize2 * horizontal;
         pDst[2] += nBlkSize2 * horizontal;

         if ( !((k + 1) % nBlkX)  )
         {
            pDst[0] += nBlkSize  * vertical * pPitches[0] - nWidth * horizontal;
            pDst[1] += nBlkSize2 * vertical * pPitches[1] - (nWidth / 2) * horizontal;
            pDst[2] += nBlkSize2 * vertical * pPitches[2] - (nWidth / 2) * horizontal;
         }
      }
	  _asm emms; // Fizick
      PROFILE_STOP(MOTION_PROFILE_COMPENSATION);
   }
   else {
      if ( !scBehavior && ( n + off < vi.num_frames ) && ( n + off >= 0 ))
         dst = child->GetFrame(n + off, env);
      else
         dst = src;
   }
   return dst;
}