#ifndef __MV_INCREASE_H__
#define __MV_INCREASE_H__

#include "MVInterface.h"
#include "CopyCode.h"

//#define DYNAMIC_COMPILE 1

#ifdef DYNAMIC_COMPILE
#include "SWCopyCode.h"
#endif

/*! \brief Filter that denoise the picture
 */
class MVIncrease : public GenericVideoFilter, public MVFilter {
private:

   MVClip mvClip;

#ifdef DYNAMIC_COMPILE
   SWCopy *copyLuma;
   SWCopy *copyChroma;
#endif

   bool scBehavior;
   bool isse;
   bool mmx;
   int vertical;
   int horizontal;

   int nBlkSize2;

   COPYFunction *BLITLUMA;
   COPYFunction *BLITCHROMA;

public:
	MVIncrease(PClip _child, PClip vectors, int vertical, int horizontal, bool scBehavior, int nIdx,
              int nSCD1, int nSCD2, bool mmx, bool isse, IScriptEnvironment* env);
	~MVIncrease();
	PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env);
};

#endif