
// Change the number of frames of the clip without changing its speed

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#ifndef __MV_INTERPOLATE__
#define __MV_INTERPOLATE__

#include "GenericMotionFilter.h"

/*! \brief Filter which show the motion mask
 */
class MVInterpolate : public GenericMotionFilter {
protected:

	double relativeLength;
	int nbInterpolatedFrame;

	int halfWidth;
	int halfHeight;
	int halfBlockWidth;
	int halfBlockHeight;

	int borderWidth;
	int halfBorderWidth;
	int revBorderWidth;
	int revHalfBorderWidth;
	int firstBorderWidth;
	int halfFirstBorderWidth;
	int secondBorderWidth;
	int halfSecondBorderWidth;

	int blockValidityThreshold;

	int *compensationsy;
	int *nbcompensationsy;
	int *compensationsu;
	int *nbcompensationsu;
	int *compensationsv;
	int *nbcompensationsv;

	int *wcompensationsy;
	int *nbwcompensationsy;
	int *wcompensationsu;
	int *nbwcompensationsu;
	int *wcompensationsv;
	int *nbwcompensationsv;

	int *wwcompensationsy;
	int *nbwwcompensationsy;
	int *wwcompensationsu;
	int *nbwwcompensationsu;
	int *wwcompensationsv;
	int *nbwwcompensationsv;

	int *weights;
	int **smoothWeights;
	int **halfSmoothWeights;

	virtual double PosWeight(double pos) = 0;
	virtual double SADWeight(unsigned int sad) = 0;
	void BuildWeights(const char *str);
	void BuildSmoothWeights();
	void TreatBlock(const FakeBlockData &block, const PVideoFrame &src, double pos);
	void RevTreatBlock(const FakeBlockData &block, const PVideoFrame &src, double pos);
	void BuildBlurring(PVideoFrame &dest, const PVideoFrame &src, const PVideoFrame &srcnext);
public:
	MVInterpolate(PClip _child, const VideoInfo &vi2, int nb, double rl, int fbw, int sbw, int rbw, int bvt, const char*str, const MotionParameters &params, IScriptEnvironment* env);
	~MVInterpolate();
};

#endif