// Create an overlay mask with the motion vectors

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#include "MVMask.h"
#include <math.h>
#include <memory.h>
#include "CopyCode.h"
#include "MaskFun.h"

MVMask::MVMask(PClip _child, PClip vectors, double ml, double gm, int _kind, int Ysc,
               int nSCD1, int nSCD2, bool mmx, bool _isse, IScriptEnvironment* env) :
GenericVideoFilter(_child),
mvClip(vectors, nSCD1, nSCD2, env),
MVFilter(vectors, "MVMask", env)
{
	isse = _isse;
	fMaskNormFactor = 1.0f/ml; // Fizick
	fMaskNormFactor2 = fMaskNormFactor*fMaskNormFactor;

//	nLengthMax = pow((double(ml),gm);

	fGamma = gm;
	if ( gm < 0 )
		fGamma = 1;
    fHalfGamma = fGamma*0.5f;

	kind = _kind; // inplace of showsad

   nSceneChangeValue = (Ysc < 0) ? 0 : ((Ysc > 255) ? 255 : Ysc);

   smallMask = new unsigned char[nBlkX * nBlkY];

	nWidthB = nBlkX*(nBlkSize - nOverlap) + nOverlap;
	nHeightB = nBlkY*(nBlkSize - nOverlap) + nOverlap;

	nHeightUV = nHeight/yRatioUV; 
	nWidthUV = nWidth/2;// for YV12
	nHeightBUV = nHeightB/yRatioUV; 
	nWidthBUV = nWidthB/2;

	 int CPUF_Resize = env->GetCPUFlags();
	 if (!isse) CPUF_Resize = (CPUF_Resize & !CPUF_INTEGER_SSE) & !CPUF_SSE2;
	// old upsizer replaced by Fizick
	 upsizer = new SimpleResize(nWidthB, nHeightB, nBlkX, nBlkY, CPUF_Resize); 
	 upsizerUV = new SimpleResize(nWidthBUV, nHeightBUV, nBlkX, nBlkY, CPUF_Resize); 


	 if ( (pixelType & VideoInfo::CS_YUY2) == VideoInfo::CS_YUY2 )
   {
		DstPlanes =  new YUY2Planes(nWidth, nHeight);
   }

}


MVMask::~MVMask()
{
   if ( (pixelType & VideoInfo::CS_YUY2) == VideoInfo::CS_YUY2 )
   {
	delete DstPlanes;
   }
	delete smallMask;
	delete upsizer;
	delete upsizerUV;
}

unsigned char MVMask::Length(VECTOR v, unsigned char pel)
{
	double norme = double(v.x * v.x + v.y * v.y) / ( pel * pel);

//	double l = 255 * pow(norme,nGamma) / nLengthMax;
	double l = 255 * pow(norme*fMaskNormFactor2, fHalfGamma); //Fizick - simply rewritten

	return (unsigned char)((l > 255) ? 255 : l) ;
}

unsigned char MVMask::SAD(unsigned int s)
{
//	double l = 255 * pow(s, nGamma) / nLengthMax);
	double l = 255 * pow((s*4*fMaskNormFactor)/(nBlkSize*nBlkSize), fGamma); // Fizick - now linear for gm=1
	return (unsigned char)((l > 255) ? 255 : l);
}

PVideoFrame __stdcall MVMask::GetFrame(int n, IScriptEnvironment* env)
{
	PVideoFrame	dst = env->NewVideoFrame(vi);
	  int dummyplane = PLANAR_Y; // use luma plane resizer code for all planes if we resize from luma small mask
   BYTE *pDst[3];
    int nDstPitches[3];
	unsigned char *pDstYUY2;
	int nDstPitchYUY2;

   mvClip.Update(n, env);
   		if ( (pixelType & VideoInfo::CS_YUY2) == VideoInfo::CS_YUY2 )
		{
			pDstYUY2 = dst->GetWritePtr();
			nDstPitchYUY2 = dst->GetPitch();
			pDst[0] = DstPlanes->GetPtr();
			pDst[1] = DstPlanes->GetPtrU();
			pDst[2] = DstPlanes->GetPtrV();
			nDstPitches[0]  = DstPlanes->GetPitch();
			nDstPitches[1]  = DstPlanes->GetPitchUV();
			nDstPitches[2]  = DstPlanes->GetPitchUV();
			YUY2ToPlanes(pDstYUY2, nDstPitchYUY2, nWidth, nHeight, 
				pDst[0], nDstPitches[0], pDst[1], pDst[2], nDstPitches[1], isse);
		}
		else
		{
		 pDst[0] = YWPLAN(dst);
         pDst[1] = UWPLAN(dst);
         pDst[2] = VWPLAN(dst);
         nDstPitches[0] = YPITCH(dst);
         nDstPitches[1] = UPITCH(dst);
         nDstPitches[2] = VPITCH(dst);
		}

	if ( mvClip.IsUsable() )
	{
		if (kind==0) // vector length mask
		{	
			for ( int j = 0; j < nBlkCount; j++)
				smallMask[j] = Length(mvClip.GetBlock(0, j).GetMV(), mvClip.GetPel());
		}
		else if (kind==1) // SAD mask
		{
			for ( int j = 0; j < nBlkCount; j++)
				smallMask[j] = SAD(mvClip.GetBlock(0, j).GetSAD());
		}
		else if (kind==2) // occlusion mask
		{
			MakeVectorOcclusionMask(mvClip, nBlkX, nBlkY, fMaskNormFactor, fGamma, nPel, smallMask, nBlkX) ;
		}


		upsizer->SimpleResizeDo(pDst[0], nWidthB, nHeightB, nDstPitches[0], smallMask, nBlkX, nBlkX, dummyplane);
		if (nWidth>nWidthB)
			for (int h=0; h<nHeight; h++)
				for (int w=nWidthB; w<nWidth; w++)
					*(pDst[0]+h*nDstPitches[0]+w) = *(pDst[0]+h*nDstPitches[0]+nWidthB-1);
		if (nHeight>nHeightB)
			env->BitBlt(pDst[0]+nHeightB*nDstPitches[0],nDstPitches[0],pDst[0]+(nHeightB-1)*nDstPitches[0],nDstPitches[0],nWidth, nHeight-nHeightB);
		upsizerUV->SimpleResizeDo(pDst[1], nWidthBUV, nHeightBUV, nDstPitches[1], smallMask, nBlkX, nBlkX, dummyplane);
		upsizerUV->SimpleResizeDo(pDst[2], nWidthBUV, nHeightBUV, nDstPitches[2], smallMask, nBlkX, nBlkX, dummyplane);
		if (nWidthUV>nWidthBUV)
			for (int h=0; h<nHeightUV; h++)
				for (int w=nWidthBUV; w<nWidthUV; w++)
				{
					*(pDst[1]+h*nDstPitches[1]+w) = *(pDst[1]+h*nDstPitches[1]+nWidthBUV-1);
					*(pDst[2]+h*nDstPitches[2]+w) = *(pDst[2]+h*nDstPitches[2]+nWidthBUV-1);
				}
		if (nHeightUV>nHeightBUV)
		{
			env->BitBlt(pDst[1]+nHeightBUV*nDstPitches[1],nDstPitches[1],pDst[1]+(nHeightBUV-1)*nDstPitches[1],nDstPitches[1],nWidthUV, nHeightUV-nHeightBUV);
			env->BitBlt(pDst[2]+nHeightBUV*nDstPitches[2],nDstPitches[2],pDst[2]+(nHeightBUV-1)*nDstPitches[2],nDstPitches[2],nWidthUV, nHeightUV-nHeightBUV);
		}

	}
	else {
		MemZoneSet(pDst[0], nSceneChangeValue, nWidth, nHeight, 0, 0, nDstPitches[0]);
		MemZoneSet(pDst[1], nSceneChangeValue, nWidthUV, nHeightUV, 0, 0, nDstPitches[1]);
		MemZoneSet(pDst[2], nSceneChangeValue, nWidthUV, nHeightUV, 0, 0, nDstPitches[2]);
	}


		if ( (pixelType & VideoInfo::CS_YUY2) == VideoInfo::CS_YUY2 )
		{
			YUY2FromPlanes(pDstYUY2, nDstPitchYUY2, nWidth, nHeight,
								  pDst[0], nDstPitches[0], pDst[1], pDst[2], nDstPitches[1], isse);
		}
	return dst;
}