// Create an overlay mask with the motion vectors

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#ifndef __MASKFUN__
#define __MASKFUN__

#include "MVInterface.h"

void MakeVectorOcclusionMask(MVClip &mvClip, int nBlkX, int nBlkY, double fMaskNormFactor, double fGamma, int nPel, BYTE * smallMask, int pitch);

void VectorMasksToOcclusionMask(BYTE *VX, BYTE *VY, int nBlkX, int nBlkY, double fMaskNormFactor, double fGamma, int nPel, BYTE * smallMask);

void MakeVectorSmallMasks(MVClip &mvClip, int nX, int nY, BYTE *VXSmallY, int pitchVXSmallY, BYTE *VYSmallY, int pitchVYSmallY);
void VectorSmallMaskYToHalfUV(BYTE * VSmallY, int nBlkX, int nBlkY, BYTE *VSmallUV, int ratioUV);

void Merge4PlanesToBig(BYTE *pel2Plane, int pel2Pitch, const BYTE *pPlane0, const BYTE *pPlane1, 
					  const BYTE *pPlane2, const BYTE * pPlane3, int width, int height, int pitch, bool isse);

#endif