// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#include "MVInterface.h"
#include <string.h>

MotionParameters::MotionParameters(int thSCD1, int thSCD2, bool _mmx, bool _isse)
{
   nThSCD1 = thSCD1;
   nThSCD2 = thSCD2;
	mmx = _mmx;
	isse = _isse;
}

MotionParameters::MotionParameters(const char *preset)
{
	if (!lstrcmpi(preset,"default")) GenericPreset();
	else GenericPreset();
}

MotionParameters::MotionParameters(AVSValue args, int offset)
{
	MotionParameters *defaultParams = new MotionParameters(args[iPreset + offset].AsString());

	nThSCD1 = (args[iSCD1Threshold + offset].Defined()) ? args[iSCD1Threshold + offset].AsInt() : defaultParams->nThSCD1;
	nThSCD2 = (args[iSCD2Threshold + offset].Defined()) ? args[iSCD2Threshold + offset].AsInt() : defaultParams->nThSCD2;
	mmx = (args[iuseMMXOptimizations + offset].Defined()) ? args[iuseMMXOptimizations + offset].AsBool() : defaultParams->mmx;
	isse = (args[iuseiSSEOptimizations + offset].Defined()) ? args[iuseiSSEOptimizations + offset].AsBool() : defaultParams->isse;

	delete defaultParams;
}


MotionParameters::MotionParameters()
{
	GenericPreset();
}

MotionParameters::MotionParameters(const MotionParameters &params)
{
	nThSCD1 = params.nThSCD1;
	nThSCD2 = params.nThSCD2;
	mmx = params.mmx;
	isse = params.isse;
}

MotionParameters::~MotionParameters()
{
}

void MotionParameters::GenericPreset()
{
	nThSCD1 = 300;
	nThSCD2 = 130;
	mmx = true;
	isse = true;
}