// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#ifndef __MOTIONPARAM__
#define __MOTIONPARAM__

#include "avisynth.h"

class MotionParameters
{
protected : 
	friend class GenericMotionFilter;
	int nThSCD1;
	int nThSCD2;
	bool mmx;
	bool isse;

	static const int iSCD1Threshold = 0;
	static const int iSCD2Threshold = 1;
	static const int iuseMMXOptimizations = 2;
	static const int iuseiSSEOptimizations = 3;
	static const int iPreset = 4;

	void GenericPreset();

public:
	MotionParameters(int thSCD1, int thSCD2, bool _mmx, bool _isse);
	MotionParameters(AVSValue args, int offset);
	MotionParameters(const MotionParameters &params);
	MotionParameters();
	MotionParameters(const char *preset);
	~MotionParameters();
};

#endif