#include "Padding.h"

void PadCorner(unsigned char *p, unsigned char v, int hPad, int vPad, int refPitch)
{
	for ( int i = 0; i < vPad; i++ )
	{
		for ( int j = 0; j < hPad; j++ )
		{
			p[j] = v;
		}
		p += refPitch;
	}
}

Padding::Padding(PClip _child, int hPad, int vPad, IScriptEnvironment* env) :
GenericVideoFilter(_child)
{
	if ( !vi.IsYV12() )
		env->ThrowError("Padding : clip must be in the YV12 color format");

	horizontalPadding = hPad;
	verticalPadding = vPad;

	vi.width += horizontalPadding * 2;
	vi.height += verticalPadding * 2;
}

Padding::~Padding()
{
}

PVideoFrame __stdcall Padding::GetFrame(int n, IScriptEnvironment *env)
{
	PVideoFrame src = child->GetFrame(n, env);
	PVideoFrame dst = env->NewVideoFrame(vi);

	const unsigned char *srcp = src->GetReadPtr(PLANAR_Y);
	unsigned char *dstp = dst->GetWritePtr(PLANAR_Y);
	int pitch = dst->GetPitch(PLANAR_Y);
	int width = dst->GetRowSize(PLANAR_Y) - 2 * horizontalPadding;
	int height = dst->GetHeight(PLANAR_Y) - 2 * verticalPadding;

	env->BitBlt(dstp + horizontalPadding + verticalPadding * pitch, pitch,
		srcp, src->GetPitch(PLANAR_Y), width, height);
	PadReferenceFrame(dstp, pitch, horizontalPadding, verticalPadding, width, height);

	srcp = src->GetReadPtr(PLANAR_U);
	dstp = dst->GetWritePtr(PLANAR_U);
	pitch = dst->GetPitch(PLANAR_U);
	width = dst->GetRowSize(PLANAR_U) - horizontalPadding;
	height = dst->GetHeight(PLANAR_U) - verticalPadding;

	env->BitBlt(dstp + (horizontalPadding / 2) + (verticalPadding / 2) * pitch, pitch,
		srcp, src->GetPitch(PLANAR_U), width, height);
	PadReferenceFrame(dstp, pitch, (horizontalPadding / 2), (verticalPadding / 2), width, height);

	srcp = src->GetReadPtr(PLANAR_V);
	dstp = dst->GetWritePtr(PLANAR_V);
	pitch = dst->GetPitch(PLANAR_V);
	width = dst->GetRowSize(PLANAR_V) - horizontalPadding;
	height = dst->GetHeight(PLANAR_V) - verticalPadding;

	env->BitBlt(dstp + (horizontalPadding / 2) + (verticalPadding / 2) * pitch, pitch,
		srcp, src->GetPitch(PLANAR_V), width, height);
	PadReferenceFrame(dstp, pitch, (horizontalPadding / 2), (verticalPadding / 2), width, height);

	return dst;
}

void Padding::PadReferenceFrame(unsigned char *refFrame, int refPitch, int hPad, int vPad, int width, int height)
{
	unsigned char value;
	unsigned char *pfoff = refFrame + vPad * refPitch + hPad;
	unsigned char *p;

	// Up-Left
	PadCorner(refFrame, pfoff[0], hPad, vPad, refPitch);
	// Up-Right
	PadCorner(refFrame + hPad + width, pfoff[width - 1], hPad, vPad, refPitch);
	// Down-Left
	PadCorner(refFrame + (vPad + height) * refPitch,
		pfoff[(height - 1) * refPitch], hPad, vPad, refPitch);
	// Down-Right
	PadCorner(refFrame + hPad + width + (vPad + height) * refPitch,
		pfoff[(height - 1) * refPitch + width - 1], hPad, vPad, refPitch);

	// Up
	for ( int i = 0; i < width; i++ )
	{
		value = pfoff[i];
		p = refFrame + hPad + i;
		for ( int j = 0; j < vPad; j++ )
		{
			p[0] = value;
			p += refPitch;
		}
	}

	// Left
	for ( int i = 0; i < height; i++ )
	{
		value = pfoff[i*refPitch];
		p = refFrame + (vPad + i) * refPitch;
		for ( int j = 0; j < hPad; j++ )
			p[j] = value;
	}

	// Right
	for ( int i = 0; i < height; i++ )
	{
		value = pfoff[i * refPitch + width - 1];
		p = refFrame + (vPad + i) * refPitch + width + hPad;
		for ( int j = 0; j < hPad; j++ )
			p[j] = value;
	}

	// Down
	for ( int i = 0; i < width; i++ )
	{
		value = pfoff[i + (height - 1) * refPitch];
		p = refFrame + hPad + i + (height + vPad) * refPitch;
		for ( int j = 0; j < vPad; j++ )
		{
			p[0] = value;
			p += refPitch;
		}
	}
}
