;/****************************************************************************
; * $Id$
; *
; ***************************************************************************/

BITS 32

%macro cglobal 1
	%ifdef PREFIX
		global _%1
		%define %1 _%1
	%else
		global %1
	%endif
%endmacro

%ifdef __DEBUG
	%define __emms emms
%else
	%define __emms
%endif

;=============================================================================
; Read only data
;=============================================================================

SECTION .rodata data align=16

ALIGN 16
mmx_one:
	times 4	dw 1
	
;=============================================================================
; Macros
;=============================================================================

%macro SAD16x2 0
	movq mm2, [eax]
	movq mm3, [eax + 8]
	movq mm4, [eax + ecx]
	movq mm5, [eax + ecx + 8]
	
	psadbw mm2, [ebx]
	psadbw mm3, [ebx + 8]
	psadbw mm4, [ebx + edx]
	psadbw mm5, [ebx + edx + 8]

	lea eax, [eax + 2 * ecx]	
	lea ebx, [ebx + 2 * edx]
	
	paddd mm0, mm2
	paddd mm1, mm3
	paddd mm0, mm4
	paddd mm1, mm5
%endmacro
	


;=============================================================================
; Code
;=============================================================================

SECTION .text

cglobal Sad16x16_iSSE

;-----------------------------------------------------------------------------
;
; unsigned int Sad16x16_iSSE(const unsigned char * cur,
;							 const unsigned char * ref,
;							 const unsigned int cpitch,
;							 const unsigned int rpitch);
;
;-----------------------------------------------------------------------------

ALIGN 16
Sad16x16_iSSE:

    push ebx

    mov eax, [esp+4+ 4]		; cur
    mov ebx, [esp+4+ 8]		; ref
    mov ecx, [esp+4+12]		; cpitch
    mov edx, [esp+4+16]		; dpitch
    
    pxor mm0, mm0
    pxor mm1, mm1
    
    SAD16x2
    SAD16x2
    SAD16x2
    SAD16x2
    SAD16x2
    SAD16x2
    SAD16x2
    SAD16x2

	paddd  mm0, mm1
	movd   eax, mm0

	pop ebx
		
	ret