;/****************************************************************************
; * $Id$
; * Copyrigt(2006) Fizick under GNU GPL license v.2
; ***************************************************************************/

BITS 32

%macro cglobal 1
	%ifdef PREFIX
		global _%1
		%define %1 _%1
	%else
		global %1
	%endif
%endmacro

%ifdef __DEBUG
	%define __emms emms
%else
	%define __emms
%endif

;=============================================================================
; Read only data
;=============================================================================

SECTION .rodata data align=16

ALIGN 16
mmx_one:
	times 4	dw 1
	
;=============================================================================
; Macros
;=============================================================================


;=============================================================================
; Code
;=============================================================================

SECTION .text

cglobal Sad8x16_iSSE


;-----------------------------------------------------------------------------
;
; unsigned int Sad8x16_iSSE(unsigned char *pCur, const unsigned char *pRef,
;				 int nCurPitch, int nRefPitch); 8 bytes, 16 lines - added by Fizick
;
;-----------------------------------------------------------------------------

ALIGN 16

Sad8x16_iSSE:
		push edi
		push esi
		
		mov edi, [esp + 12] ; cur
		mov esi, [esp + 16] ; ref
		mov edx, [esp + 20] ; curpitch
		mov ecx, [esp + 24] ; refpitch
		
		pxor mm4, mm4 ; zero

        movq mm0, [esi]				; 0 ->
		psadbw mm0, [edi]
        movq mm1, [esi + ecx]       ; 1 ->
		psadbw mm1, [edi + edx]
        movq mm2, [esi + 2 * ecx]   ; 2 ->
		psadbw mm2, [edi + 2 *edx]
        movq mm3, [esi + 4 * ecx]   ; 4 ->
        psadbw mm3, [edi + 4 * edx]
		
		paddd mm0, mm1
		paddd mm2, mm3

		paddd mm4, mm0   
		paddd mm4, mm2

        lea esi, [esi + ecx * 2]    ; 2
        lea edi, [edi + edx * 2]    ; 2

        movq mm0, [esi + ecx]       ; 2 + 1 ->
        psadbw mm0, [edi + edx] 
        movq mm1, [esi + 4 * ecx]   ; 2 + 4 ->
        psadbw mm1, [edi + 4 * edx]

        lea esi, [esi + ecx]        ; 3
        lea edi, [edi + edx]        ; 3

        movq mm2, [esi + 2 * ecx]   ; 3 + 2 ->
        psadbw mm2, [edi + 2 * edx]
        movq mm3, [esi + 4 * ecx]   ; 3 + 4 ->
        psadbw mm3, [edi + 4 * edx]

		paddd mm0, mm1
		paddd mm2, mm3

		paddd mm4, mm0   
		paddd mm4, mm2

; pointer to next 8 lines
        
        lea esi, [esi + ecx *4]        ; 7
        lea edi, [edi + edx *4]        ; 7

        lea esi, [esi + ecx]        ; 8
        lea edi, [edi + edx]        ; 8

; next 8 lines

        movq mm0, [esi]				; 0 ->
		psadbw mm0, [edi]
        movq mm1, [esi + ecx]       ; 1 ->
		psadbw mm1, [edi + edx]
        movq mm2, [esi + 2 * ecx]   ; 2 ->
		psadbw mm2, [edi + 2 *edx]
        movq mm3, [esi + 4 * ecx]   ; 4 ->
        psadbw mm3, [edi + 4 * edx]
		
		paddd mm0, mm1
		paddd mm2, mm3

		paddd mm4, mm0   
		paddd mm4, mm2

        lea esi, [esi + ecx * 2]    ; 2
        lea edi, [edi + edx * 2]    ; 2

        movq mm0, [esi + ecx]       ; 2 + 1 ->
        psadbw mm0, [edi + edx] 
        movq mm1, [esi + 4 * ecx]   ; 2 + 4 ->
        psadbw mm1, [edi + 4 * edx]

        lea esi, [esi + ecx]        ; 3
        lea edi, [edi + edx]        ; 3

        movq mm2, [esi + 2 * ecx]   ; 3 + 2 ->
        psadbw mm2, [edi + 2 * edx]
        movq mm3, [esi + 4 * ecx]   ; 3 + 4 ->
        psadbw mm3, [edi + 4 * edx]

		paddd mm0, mm1
		paddd mm2, mm3

		paddd mm4, mm0   
		paddd mm4, mm2

		movd eax, mm4

        pop esi
        pop edi
        
        ret

