;/****************************************************************************
; * $Id$
; *
; ***************************************************************************/

BITS 32

%macro cglobal 1
	%ifdef PREFIX
		global _%1
		%define %1 _%1
	%else
		global %1
	%endif
%endmacro

;=============================================================================
; Read only data
;=============================================================================

SECTION .rodata data align=16

ALIGN 16
mmx_one:
	times 4	dw 1
	
;=============================================================================
; Macros
;=============================================================================


;=============================================================================
; Code
;=============================================================================

SECTION .text

cglobal SAD8x4_iSSE

;-----------------------------------------------------------------------------
;
; unsigned int SAD8x4_iSSE(const unsigned char * cur,
;						   const unsigned char * ref,
;						   const unsigned int cpitch,
;						   const unsigned int rpitch);
;
;-----------------------------------------------------------------------------

ALIGN 16
SAD8x4_iSSE:
	push ebx
    mov eax, [esp+4+ 4]		; cur
    mov ebx, [esp+4+ 8]		; ref
    mov ecx, [esp+4+12]		; cpitch
    mov edx, [esp+4+16]		; dpitch
    push esi
    push edi
    
    lea	esi, [ecx+2*ecx]    ; 3*cpitch
    lea edi, [edx+2*edx]	; 3*dpitch
   
	movq   mm0, [eax]		;0
	psadbw mm0, [ebx]
	movq   mm1, [eax+ecx]	;1
	psadbw mm1, [ebx+edx]

	movq   mm2, [eax+2*ecx]	;2
	psadbw mm2, [ebx+2*edx]
	movq   mm3, [eax+esi]	;3
	psadbw mm3, [ebx+edi]

	paddd  mm0, mm1

	paddd  mm2,	mm3
	paddd  mm0,	mm2
		
	pop edi
	pop esi
	pop ebx

	movd   eax, mm0
	
	ret