;/****************************************************************************
; * $Id$
; *
; ***************************************************************************/

BITS 32

%macro cglobal 1
	%ifdef PREFIX
		global _%1
		%define %1 _%1
	%else
		global %1
	%endif
%endmacro

%ifdef __DEBUG
	%define __emms emms
%else
	%define __emms
%endif

;=============================================================================
; Read only data
;=============================================================================

SECTION .rodata data align=16

ALIGN 16
mmx_one:
	times 4	dw 1
	
;=============================================================================
; Macros
;=============================================================================


;=============================================================================
; Code
;=============================================================================

SECTION .text

cglobal Sad8x8_iSSE

;-----------------------------------------------------------------------------
;
; unsigned int Sad8x8_iSSE(const unsigned char * cur,
;						   const unsigned char * ref,
;						   const unsigned int cpitch,
;						   const unsigned int rpitch);
;
;-----------------------------------------------------------------------------

ALIGN 16
Sad8x8_iSSE:

    push ebx

    mov eax, [esp+4+ 4]		; cur
    mov ebx, [esp+4+ 8]		; ref
    mov ecx, [esp+4+12]		; cpitch
    mov edx, [esp+4+16]		; dpitch
    
    push esi
    push edi
    
    lea	esi, [ecx+2*ecx]    ; 3*cpitch
    lea edi, [edx+2*edx]	; 3*dpitch
    
 	movq   mm0, [eax]		;0
	psadbw mm0, [ebx]
	movq   mm1, [eax+ecx]	;1
	psadbw mm1, [ebx+edx]

	movq   mm2, [eax+2*ecx]	;2
	psadbw mm2, [ebx+2*edx]
	movq   mm3, [eax+esi]	;3
	psadbw mm3, [ebx+edi]

	paddd  mm0, mm1

	movq   mm4, [eax+4*ecx]	;4
	psadbw mm4, [ebx+4*edx]
	movq   mm5, [eax+2*esi]	;6
	psadbw mm5, [ebx+2*edi]

	paddd  mm2,	mm3
	paddd  mm0,	mm2
	
	lea esi, [esi+2*ecx]	; 5*cpitch 
	lea edi, [edi+2*edx]	; 5*dpitch
	
	lea ecx, [esi+2*ecx]	; 7*cpitch
	lea edx, [edi+2*edx]	; 7*cpitch

	movq   mm6, [eax+esi]	;5
	psadbw mm6, [ebx+edi]
	movq   mm7, [eax+ecx]	;7
	psadbw mm7, [ebx+edx]
	
	paddd  mm4, mm5
	paddd  mm6, mm7
	paddd  mm0, mm4
	
	paddd  mm0, mm6
	movd   eax, mm0

	pop edi
	pop esi
	pop ebx
	
		
	ret