#include "Corrector.h"

Corrector::Corrector(PClip _child, AVSValue clips, int mode, int th, IScriptEnvironment *env) :
GenericVideoFilter(_child)
{
   if ( !(clips.ArraySize() & 1) )
      env->ThrowError("Corrector : there is not the same number of analysis and output clips");

   nClips = clips.ArraySize() / 2;
   AClip = _child;
   OClip = clips[0].AsClip();

   for ( int i = 0; i < nClips; i ++ )
   {
      AClips.push_back(clips[i+1].AsClip());
      OClips.push_back(clips[i+nClips+1].AsClip());
   }

   nWidth = vi.width;
   nHeight = vi.height;

   if ( mode == 1)
      Process = ProcessBest;
   else
      Process = ProcessMean;

   nThreshold = th;
}

Corrector::~Corrector()
{
}

void ProcessMean(Uint8 *pDst, const Uint8 *pASrc, const Uint8 *pOSrc, const Uint8 **pASrcs, const Uint8 **pOSrcs, 
                 int nDstPitch, int nASrcPitch, int nOSrcPitch, int *pAPitches, int *pOPitches, int width, int height, int nThreshold, int nClips)
{
   int nSum;
   int nCount;
   for ( int y = 0; y < height; y++ )
   {
      for ( int x = 0; x < width; x++ )
      {
         nCount = nSum = 0;
         for ( int i = 0; i < nClips; i++ )
         {
            if ( abs(pASrcs[i][x] - pASrc[x]) < nThreshold )
            {
               nSum += pOSrcs[i][x];
               nCount++;
            }
         }
         if ( nCount )
            pDst[x] = (nSum + (nCount >> 1)) / nCount;
         else
            pDst[x] = pOSrc[x];
      }
      for ( int i = 0; i < nClips; i++ )
      {
         pASrcs[i] += pAPitches[i];
         pOSrcs[i] += pOPitches[i];
      }
      pASrc += nASrcPitch;
      pOSrc += nOSrcPitch;
      pDst += nDstPitch;
   }
}

void ProcessBest(Uint8 *pDst, const Uint8 *pASrc, const Uint8 *pOSrc, const Uint8 **pASrcs, const Uint8 **pOSrcs, 
                 int nDstPitch, int nASrcPitch, int nOSrcPitch, int *pAPitches, int *pOPitches, int width, int height, int nThreshold, int nClips)
{
   int nMin;
   int nVal;
   for ( int y = 0; y < height; y++ )
   {
      for ( int x = 0; x < width; x++ )
      {
         nMin = nThreshold;
         nVal = -1;
         for ( int i = 0; i < nClips; i++ )
         {
            if ( abs(pASrcs[i][x] - pASrc[x]) < nMin )
            {
               nVal = pOSrcs[i][x];
               nMin = abs(pASrcs[i][x] - pASrc[x]);
            }
         }
         if ( nVal == -1 )
            pDst[x] = pOSrc[x];
         else
            pDst[x] = nVal;
      }
      for ( int i = 0; i < nClips; i++ )
      {
         pASrcs[i] += pAPitches[i];
         pOSrcs[i] += pOPitches[i];
      }
      pASrc += nASrcPitch;
      pOSrc += nOSrcPitch;
      pDst += nDstPitch;
   }
}


PVideoFrame __stdcall Corrector::GetFrame(int n, IScriptEnvironment* env)
{
   PVideoFrame ASrc = AClip->GetFrame(n, env);
   PVideoFrame OSrc = OClip->GetFrame(n, env);

   PVideoFrame dst = env->NewVideoFrame(vi);
   env->MakeWritable(&dst);

   const Uint8 **pASrcs = new const Uint8*[nClips];
   const Uint8 **pOSrcs = new const Uint8*[nClips];
   int *pAPitches = new int[nClips];
   int *pOPitches = new int[nClips];
   for ( int i = 0; i < nClips; i++ )
   {
      pASrcs[i] = YRPLAN(AClips[i]->GetFrame(n, env));
      pAPitches[i] = YPITCH(AClips[i]->GetFrame(n, env));
      pOSrcs[i] = YRPLAN(OClips[i]->GetFrame(n, env));
      pOPitches[i] = YPITCH(OClips[i]->GetFrame(n, env));
   }

   Process(YWPLAN(dst), YRPLAN(ASrc), YRPLAN(OSrc), pASrcs, pOSrcs,
           YPITCH(dst), YPITCH(ASrc), YPITCH(OSrc), pAPitches, pOPitches,
           nWidth, nHeight, nThreshold, nClips);

   for ( int i = 0; i < nClips; i++ )
   {
      pASrcs[i] = URPLAN(AClips[i]->GetFrame(n, env));
      pAPitches[i] = UPITCH(AClips[i]->GetFrame(n, env));
      pOSrcs[i] = URPLAN(OClips[i]->GetFrame(n, env));
      pOPitches[i] = UPITCH(OClips[i]->GetFrame(n, env));
   }

   Process(UWPLAN(dst), URPLAN(ASrc), URPLAN(OSrc), pASrcs, pOSrcs,
           UPITCH(dst), UPITCH(ASrc), UPITCH(OSrc), pAPitches, pOPitches,
           nWidth / 2, nHeight / 2, nThreshold, nClips);

   for ( int i = 0; i < nClips; i++ )
   {
      pASrcs[i] = VRPLAN(AClips[i]->GetFrame(n, env));
      pAPitches[i] = VPITCH(AClips[i]->GetFrame(n, env));
      pOSrcs[i] = VRPLAN(OClips[i]->GetFrame(n, env));
      pOPitches[i] = VPITCH(OClips[i]->GetFrame(n, env));
   }

   Process(VWPLAN(dst), VRPLAN(ASrc), VRPLAN(OSrc), pASrcs, pOSrcs,
           VPITCH(dst), VPITCH(ASrc), VPITCH(OSrc), pAPitches, pOPitches,
           nWidth / 2, nHeight / 2, nThreshold, nClips);

   delete[] pASrcs;
   delete[] pAPitches;
   delete[] pOSrcs;
   delete[] pOPitches;

   return dst;
}