#ifndef __CORRECTOR__
#define __CORRECTOR__

#include "avisynth.h"
#include "MVInterface.h"
#include <vector>

void ProcessMean(Uint8 *pDst, const Uint8 *pASrc, const Uint8 *pOSrc, const Uint8 **pASrcs, const Uint8 **pOSrcs, 
                 int nDstPitch, int nASrcPitch, int nOSrcPitch, int *pAPitches, int *pOPitches, int width, int height, int nThreshold, int nClips);
void ProcessBest(Uint8 *pDst, const Uint8 *pASrc, const Uint8 *pOSrc, const Uint8 **pASrcs, const Uint8 **pOSrcs, 
                 int nDstPitch, int nASrcPitch, int nOSrcPitch, int *pAPitches, int *pOPitches, int width, int height, int nThreshold, int nClips);

typedef std::vector<PClip> ClipArray;

class Corrector : public GenericVideoFilter {
private:
   ClipArray AClips;
   ClipArray OClips;
   PClip AClip;
   PClip OClip;
   int nWidth;
   int nHeight;
   int nThreshold;
   int nClips;

public:
	Corrector(PClip _child, AVSValue clips, int mode, int th, IScriptEnvironment* env);
   ~Corrector();

   void (* Process)(Uint8 *pDst, const Uint8 *pASrc, const Uint8 *pOSrc, const Uint8 **pASrcs, const Uint8 **pOSrcs, 
                    int nDstPitch, int nASrcPitch, int nOSrcPitch, int *pAPitches, int *pOPitches, int width, int height, int nThreshold, int nClips);


	PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env);
};

#endif