#include "Deblock.h"
#include "MVInterface.h"

#define DEBLOCK_QUANT_MAX 60 // generalized by Fizick (was max=51)

Deblock::Deblock(PClip _child, int q, int aOff, int bOff, bool _mmx, bool _isse,
                 IScriptEnvironment* env) :
GenericVideoFilter(_child)
{
    nQuant = sat(q, 0, DEBLOCK_QUANT_MAX);
//    nAOffset = sat(aOff, -nQuant, 51 - nQuant);
//    nBOffset = sat(bOff, -nQuant, 51 - nQuant);
    nAOffset = sat(aOff, -nQuant, DEBLOCK_QUANT_MAX - nQuant);
    nBOffset = sat(bOff, -nQuant, DEBLOCK_QUANT_MAX - nQuant);
    nWidth = vi.width;
    nHeight = vi.height;

    if ( !vi.IsYV12() && !vi.IsYUY2() )
        env->ThrowError("Deblock : need YV12 or YUY2 input");
    if (( nWidth & 7 ) || ( nHeight & 7 ))
        env->ThrowError("Deblock : width and height must be mod 8");
	 if ( vi.IsYUY2() )
   		SrcPlanes =  new YUY2Planes(nWidth, nHeight);
   
}

Deblock::~Deblock()
{
   if ( vi.IsYUY2() )
		delete SrcPlanes;
   
}

const int alphas[DEBLOCK_QUANT_MAX+1] = {
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 4, 4,
    5, 6, 7, 8, 9, 10,
    12, 13, 15, 17, 20,
    22, 25, 28, 32, 36,
    40, 45, 50, 56, 63, 
    71, 80, 90, 101, 113,
    127, 144, 162, 182,
    203, 226, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255 // added by Fizick 
};

const int betas[DEBLOCK_QUANT_MAX+1] = {
    0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 2,
    2, 3, 3, 3, 3, 4,
    4, 4, 6, 6, 
    7, 7, 8, 8, 9, 9,
    10, 10, 11, 11, 12,
    12, 13, 13, 14, 14, 
    15, 15, 16, 16, 17, 
    17, 18, 18,
	19, 20, 21, 22, 23, 24, 25, 26, 27 // added by Fizick 
};

const int cs[DEBLOCK_QUANT_MAX+1] = {
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 
    1, 2, 2, 2, 2, 3, 
    3, 3, 4, 4, 5, 5,
    6, 7, 8, 8, 10, 
    11, 12, 13, 15, 17,
	19, 21, 23, 25, 27, 29, 31, 33, 35 // added by Fizick for really strong deblocking :)
};



void Deblock::DeblockPicture(unsigned char *srcp, int srcPitch, int w, int h,
                             int q, int aOff, int bOff)
{
    int indexa, indexb;
    for ( int j = 0; j < h; j += 4 )
    {
        for ( int i = 0; i < w; i += 4 )
        {
            indexa = sat(q + aOff, 0, DEBLOCK_QUANT_MAX);
            indexb = sat(q + bOff, 0, DEBLOCK_QUANT_MAX);
            if ( j > 0 )
                DeblockHorEdge(srcp + i, srcPitch, indexa, indexb);
            if ( i > 0 )
                DeblockVerEdge(srcp + i, srcPitch, indexa, indexb);
        }
        srcp += 4 * srcPitch;
    }
}

void Deblock::DeblockHorEdge(unsigned char *srcp, int srcPitch, int ia, int ib)
{
    int alpha = alphas[ia];
    int beta = betas[ib];
    int c, c0 = cs[ia];
    unsigned char *sq0 = srcp;
    unsigned char *sq1 = srcp + srcPitch;
    unsigned char *sq2 = srcp + 2 * srcPitch;
    unsigned char *sp0 = srcp - srcPitch;
    unsigned char *sp1 = srcp - 2 * srcPitch;
    unsigned char *sp2 = srcp - 3 * srcPitch;
    int delta, ap, aq, deltap1, deltaq1;

    for ( int i = 0; i < 4; i ++ )
    {
        if (( abs(sp0[i] - sq0[i]) < alpha ) && ( abs(sp1[i] - sp0[i]) < beta ) && ( abs(sq0[i] - sq1[i]) < beta ))
        {
            ap = abs(sp2[i] - sp0[i]);
            aq = abs(sq2[i] - sq0[i]);
            c = c0;
            if ( aq < beta ) c++;
            if ( ap < beta ) c++;
            delta = sat((((sq0[i] - sp0[i]) << 2) + (sp1[i] - sq1[i]) + 4) >> 3, -c, c);
            deltap1 = sat((sp2[i] + ((sp0[i] + sq0[i] + 1) >> 1) - (sp1[i] << 1)) >> 1, -c0, c0);
            deltaq1 = sat((sq2[i] + ((sp0[i] + sq0[i] + 1) >> 1) - (sq1[i] << 1)) >> 1, -c0, c0);
            sp0[i] = (unsigned char)sat(sp0[i] + delta, 0, 255);
            sq0[i] = (unsigned char)sat(sq0[i] - delta, 0, 255);
            if ( ap < beta )
                sp1[i] = (unsigned char)(sp1[i] + deltap1);
            if ( aq < beta )
                sq1[i] = (unsigned char)(sq1[i] + deltaq1);
        }
    }
}

void Deblock::DeblockVerEdge(unsigned char *srcp, int srcPitch, int ia, int ib)
{
    int alpha = alphas[ia];
    int beta = betas[ib];
    int c, c0 = cs[ia];
    unsigned char *s = srcp;

    int delta, ap, aq, deltap1, deltaq1;

    for ( int i = 0; i < 4; i ++ )
    {
        if (( abs(s[0] - s[-1]) < alpha ) && ( abs(s[1] - s[0]) < beta ) && ( abs(s[-1] - s[-2]) < beta ))
        {
            ap = abs(s[2] - s[0]);
            aq = abs(s[-3] - s[-1]);
            c = c0;
            if ( aq < beta ) c++;
            if ( ap < beta ) c++;
            delta = sat((((s[0] - s[-1]) << 2) + (s[-2] - s[1]) + 4) >> 3, -c, c);
            deltaq1 = sat((s[2] + ((s[0] + s[-1] + 1) >> 1) - (s[1] << 1)) >> 1, -c0, c0);
            deltap1 = sat((s[-3] + ((s[0] + s[-1] + 1) >> 1) - (s[-2] << 1)) >> 1, -c0, c0);
            s[0] = (unsigned char)sat(s[0] - delta, 0, 255);
            s[-1] = (unsigned char)sat(s[-1] + delta, 0, 255);
            if ( ap < beta )
                s[1] = (unsigned char)(s[1] + deltaq1);
            if ( aq < beta )
                s[-2] = (unsigned char)(s[-2] + deltap1);
        }
        s += srcPitch;
    }
}



PVideoFrame __stdcall Deblock::GetFrame(int n, IScriptEnvironment *env)
{
	unsigned char *pSrc[3];
    int nSrcPitches[3];
	unsigned char *pSrcYUY2;
	int nSrcPitchYUY2;

    PVideoFrame src = child->GetFrame(n, env);
    env->MakeWritable(&src);

  		if ( vi.IsYUY2() )
		{
			pSrcYUY2 = src->GetWritePtr();
			nSrcPitchYUY2 = src->GetPitch();
			pSrc[0] = SrcPlanes->GetPtr();
			pSrc[1] = SrcPlanes->GetPtrU();
			pSrc[2] = SrcPlanes->GetPtrV();
			nSrcPitches[0]  = SrcPlanes->GetPitch();
			nSrcPitches[1]  = SrcPlanes->GetPitchUV();
			nSrcPitches[2]  = SrcPlanes->GetPitchUV();
			YUY2ToPlanes(pSrcYUY2, nSrcPitchYUY2, nWidth, nHeight, 
				pSrc[0], nSrcPitches[0], pSrc[1], pSrc[2], nSrcPitches[1]);
		}
		else
		{
			 pSrc[0] = YWPLAN(src);
			 pSrc[1] = UWPLAN(src);
			 pSrc[2] = VWPLAN(src);
			 nSrcPitches[0] = YPITCH(src);
			 nSrcPitches[1] = UPITCH(src);
			 nSrcPitches[2] = VPITCH(src);
		}

		int yRatioUV = (vi.IsYV12()) ? 2 : 1;

    DeblockPicture(pSrc[0], nSrcPitches[0], nWidth, nHeight,
                   nQuant, nAOffset, nBOffset);
    DeblockPicture(pSrc[1], nSrcPitches[1], nWidth / 2, nHeight / yRatioUV,
                   nQuant, nAOffset, nBOffset);
    DeblockPicture(pSrc[2], nSrcPitches[2], nWidth / 2, nHeight / yRatioUV,
                   nQuant, nAOffset, nBOffset);

	if (vi.IsYUY2())
			YUY2FromPlanes(pSrcYUY2, nSrcPitchYUY2, nWidth, nHeight, pSrc[0], nSrcPitches[0], pSrc[1], pSrc[2], nSrcPitches[1]);
    return src;
}
