#ifndef __ENC_DENOISE__
#define __ENC_DENOISE__


#include "GenericMotionFilter.h"

extern "C" void __cdecl x264_sub4x4_dct_mmxext( __int16 dct[4][4],  const unsigned char *pix1, int i_pix1, const unsigned char *pix2, int i_pix2 );
extern "C" void __cdecl x264_add4x4_idct_mmxext( unsigned char *p_dst, int i_dst, __int16 dct[4][4] );

/*! \brief Filter that denoise the picture
 */
class EncDenoise : public GenericMotionFilter {
private:

	FakeGroupOfPlanes *fgop;
	PClip mvclip;
    bool scBehavior;
    int last;
    int aOffset, bOffset, quant;
    unsigned char *curFrame, *refFrame;
    unsigned char *buffer;
    int frameSize;
    int bufferPos;
    int lastf;
    int deadzone;
    int level;

protected:

    void MoveBlock(unsigned char *pDst, int dstPitch,
                   const unsigned char *pSrc, int srcPitch);
    void QDQBlock(__int16 dstp[4][4], int q, int f);
    void InterpolateDiagHpel(unsigned char *pDst, int nDstPitch,
                             const unsigned char *pSrc, int nSrcPitch);
    void InterpolateHorHpel(unsigned char *pDst, int nDstPitch,
                            const unsigned char *pSrc, int nSrcPitch);
    void InterpolateVerHpel(unsigned char *pDst, int nDstPitch,
                            const unsigned char *pSrc, int nSrcPitch);

    inline int sat(int x, int min, int max)
    { return (x < min) ? min : ((x > max) ? max : x); }

    inline int abs(int x)
    { return ( x < 0 ) ? -x : x; }

    void DeblockHorEdge(unsigned char *srcp, int srcPitch, int ia, int ib);

    void DeblockVerEdge(unsigned char *srcp, int srcPitch, int ia, int ib);
    void DeblockPicture(unsigned char *srcp, int srcPitch, int w, int h,
                        int q, int aOff, int bOff);
    void ProcessFrame(unsigned char *pDst, unsigned char *pRef, int dstPitch, 
                      const unsigned char *pSrc, int srcPitch, int w, int h, int scale);

public:
	EncDenoise(PClip _child, PClip vectors, bool sc, int q, int aOff, int bOff, int lv, int dz,
               const MotionParameters &params, IScriptEnvironment* env);
	~EncDenoise();
	PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env);
};

#endif