// General classe for motion based filters

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

//#include "GenericMotionFilter.h"
//#include "MVAnalysisData.h"
#include "MVInterface.h"

GenericMotionFilter::GenericMotionFilter(const PClip &clip, const MotionParameters &params, const PClip &vectors, IScriptEnvironment* env) :
GenericVideoFilter(clip),
MotionParameters(params)
{
	mmx = mmx && ( env->GetCPUFlags() & CPUF_MMX );
	isse = isse && ( env->GetCPUFlags() & CPUF_INTEGER_SSE );

	if ( nWidth & 7 ) env->ThrowError("GenericMotionFilter: Width has to be dividable by 8");
	if ( nHeight & 7 ) env->ThrowError("GenericMotionFilter: Height has to be dividable by 8");

   nThSCD2 = (nWidth * nHeight * nThSCD2 / (256 * nBlkSize * nBlkSize));
}

GenericMotionFilter::~GenericMotionFilter()
{
}

