// Make a motion compensate temporal denoiser

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#ifndef __GENERIC_MOTION__
#define __GENERIC_MOTION__

#include "MVInterface.h"
#include "avisynth.h"
#include "FakeGroupOfPlanes.h"
#include "MotionParameters.h"

class GenericMotionFilter : public MotionParameters {
protected:
	/*! \brief Width of the frame */
	int nWidth;
	
	/*! \brief Height of the frame */
	int nHeight;

	/*! \brief Number of blocks horizontaly, at the first level */
	int nBlkX;

	/*! \brief Number of blocks verticaly, at the first level */
	int nBlkY;

	/*! \brief Number of blocks at the first level */
	int nBlkCount;

	/*! \brief size of a block */
	int nBlkSize;

	/*! \brief Accuracy of the motion vectors, in ith of pixel */
	int nPel;

	/*! \brief Number of levels used for the search */
	int nLvCount;

	/*! \brief Do we already initialized the prevous class members */
	bool isFirstTime;

	/*! \brief Horizontal margin around the reference picture */
	int nHPadding;

	/*! \brief Vertical margin arounf the reference picture */
	int nVPadding;

	/*! \brief If only one vector's stream is given, it says whether vectors point forward or backward */
	bool isBackward;

   /*! \brief frame offset between the reference frame and the source frame */
   int nDeltaFrame;

	GenericMotionFilter(const MotionParameters &params, const VideoInfo &vectorInfo, IScriptEnvironment* env);
	~GenericMotionFilter();

	void CreateFGOP(FakeGroupOfPlanes **fgop);
	bool IsSceneChange(FakeGroupOfPlanes *fgop);
	bool IsUsable(FakeGroupOfPlanes *fgop);
	void GetVectorStream(int n, IScriptEnvironment* env, const PClip& pclip, FakeGroupOfPlanes *fgop);
   void SetVectorsNeed(IScriptEnvironment *env, const PClip &pclip, 
                       bool srcluma, bool refluma, bool var,
                       bool compy, bool compu, bool compv);
	const FakeBlockData &GetBlock(FakeGroupOfPlanes *fgop, int lv, int blk);
	
};

#endif