#include "MVBidouille.h"
#include <memory.h>
#include <string.h>
#include <stdio.h>
#include <map>
#include <utility>
#include <list>
#include <deque>
#include <algorithm>

#include "Interpolation.h"
#include "Padding.h"
#include "CopyCode.h"

MVBidouille::MVBidouille(PClip _child, PClip bwVectors, PClip fwVectors, int _nIdx, int boo,  int nSCD1, int nSCD2, bool mmx, bool isse, IScriptEnvironment* env) :
GenericVideoFilter(_child),
fwMvClip(fwVectors, nSCD1, nSCD2, env),
bwMvClip(bwVectors, nSCD1, nSCD2, env),
fwfwMvClip(fwVectors, nSCD1, nSCD2, env),
bwbwMvClip(bwVectors, nSCD1, nSCD2, env),
MVFilter(fwVectors, "MVBidouille", env)
{
   CheckSimilarity(bwMvClip, "backward vector", env);
   nIdx = _nIdx;

   nBoo = boo;

   nOBMCMargin = (nBoo & 8) ? 2 : 0;

   nExtendedWidth = nWidth;
   nExtendedHeight = nHeight;
   nExtendedPitch = (nExtendedWidth + 15) & (~15);
   nOffset = 0;
   nOffsetUV = 0;

   pTempFinal = new Pixels[nExtendedHeight * nExtendedPitch];
   pFinalDst = new PixelsList[nExtendedHeight * nExtendedPitch];

   mvCore->AddFrames(nIdx, 10, fwMvClip.GetLevelCount(), nWidth, nHeight, nPel, nBlkSize + nOBMCMargin, nBlkSize + nOBMCMargin, YUVPLANES, isse);

   nBlkSadPitch = (nBlkSize + 2 * nOBMCMargin);
   
   pBlkSadModifier = new int *[nPel * nPel];
   for ( int i = 0; i < nPel * nPel; i++ )
      pBlkSadModifier[i] = new int[(nBlkSadPitch + (i&1)) * (nBlkSadPitch + ((i&2)>>1))];

   for ( int k = 0; k < nPel * nPel; k++ )
   {
      int width = nBlkSadPitch + (k&1);
      int height = nBlkSadPitch + ((k&2)>>1);
      for ( int j = 0; j < nOBMCMargin; j++ )
         for ( int i = 0; i < width; i++ )
            pBlkSadModifier[k][i + j * width] = 2;

      for ( int j = nOBMCMargin; j < height - nOBMCMargin; j++ )
      {
         for ( int i = 0; i < nOBMCMargin; i++ )
            pBlkSadModifier[k][i + j * width] = 2;
         for ( int i = nOBMCMargin; i < width - nOBMCMargin; i++ )
            pBlkSadModifier[k][i + j * width] = 1;
         for ( int i = width - nOBMCMargin; i < width; i++ )
            pBlkSadModifier[k][i + j * width] = 2;

         DebugPrintf("%i %i %i %i %i %i %i %i %i %i %i %i\n",
            pBlkSadModifier[k][0 + j * width],
            pBlkSadModifier[k][1 + j * width],
            pBlkSadModifier[k][2 + j * width],
            pBlkSadModifier[k][3 + j * width],
            pBlkSadModifier[k][4 + j * width],
            pBlkSadModifier[k][5 + j * width],
            pBlkSadModifier[k][6 + j * width],
            pBlkSadModifier[k][7 + j * width],
            pBlkSadModifier[k][8 + j * width],
            pBlkSadModifier[k][9 + j * width],
            pBlkSadModifier[k][10 + j * width],
            pBlkSadModifier[k][11 + j * width]);


      }

      for ( int j = height - nOBMCMargin; j < height; j++ )
         for ( int i = 0; i < width; i++ )
            pBlkSadModifier[k][i + j * width] = 2;
   }
}

MVBidouille::~MVBidouille()
{
   for ( int i = 0; i < nPel * nPel; i++ )
   {
      delete[] pBlkSadModifier[i];
   }
   delete[] pBlkSadModifier;

   delete[] pTempFinal;
   delete[] pFinalDst;
}

void MVBidouille::MoveBlock(MVFrame *pFrame, const FakeBlockData& block, int nRatio, int nSadRatio, int nBlk)
{
   const unsigned char *pSrc;
   int mvx = (block.GetMV().x * nRatio) >> 10;
   int mvy = (block.GetMV().y * nRatio) >> 10;
   int offx = 0;
   int offy = 0;
   int *pWeights;

   if (nPel == 1)
   {
      pWeights = pBlkSadModifier[0];
      pSrc = pFrame->GetPlane(YPLANE)->GetPointer(block.GetX() - offx - nOBMCMargin, block.GetY() - offy - nOBMCMargin);
   }
   else
   {
      int idx = (mvx & 1) + 2 * (mvy & 1);
      offx = (idx & 1) ? 1 : 0;
      offy = (idx & 2) ? 1 : 0;
      mvx = mvx / 2;
      mvy = mvy / 2;
      pSrc = pFrame->GetPlane(YPLANE)->GetPointer(block.GetX() * 2 - offx - nOBMCMargin * 2, block.GetY() * 2 - offy - nOBMCMargin * 2);
      pWeights = pBlkSadModifier[idx];
   }


   int nX = block.GetX() + mvx - nOBMCMargin;
   int nY = block.GetY() + mvy - nOBMCMargin;

   int minX = 0;
   int minY = 0;
   int maxX = nBlkSize + offx + 2 * nOBMCMargin;
   int maxY = nBlkSize + offy + 2 * nOBMCMargin;

   if ( nX < 0 ) 
      minX += -nX;
   if ( nY < 0 )
      minY += -nY;
   if ( nX + maxX > nWidth )
      maxX = nWidth - nX;
   if ( nY + maxY > nHeight )
      maxY = nHeight - nY;

   pSrc += minY * pFrame->GetPlane(YPLANE)->GetPitch();
   pWeights += minY * ( nBlkSadPitch + offx );

   int offset = nX + nY * nExtendedPitch;

   for ( int i = minY; i < maxY; i++ )
   {
      for ( int j = minX; j < maxX; j++ )
      {
         int off = i * nExtendedPitch + j + offset;
         Pixels pix;
         pix.nBlk = pSrc[j];
         pix.nSad = block.GetSAD() * pWeights[j] * nSadRatio) >> 10;
         pix.nBlk = nBlk;
         pFinalDst[off].push_back(pix);
      }
      pSrc += pFrame->GetPlane(YPLANE)->GetPitch();
      pWeights += nBlkSadPitch + offx;
   }
}

void MVBidouille::MoveBlock(MVFrame *pFrame, MVFrame *pFrame2, const FakeBlockData& block, int nRatio, int nSadRatio, int nBlk)
{
   const unsigned char *pSrc;
   const BYTE *pSrc2;
   int mvx = (block.GetMV().x * nRatio) >> 10;
   int mvy = (block.GetMV().y * nRatio) >> 10;
   int mvx2 = block.GetMV().x * (nRatio / abs(nRatio));
   int mvy2 = block.GetMV().y * (nRatio / abs(nRatio));
   int offx = 0;
   int offy = 0;
   int offx2 = 0;
   int offy2 = 0;
   int *pWeights;

   if (nPel == 1)
   {
      pWeights = pBlkSadModifier[0];
      pSrc = pFrame->GetPlane(YPLANE)->GetPointer(block.GetX() - offx - nOBMCMargin, block.GetY() - offy - nOBMCMargin);
      pSrc2 = pFrame2->GetPlane(YPLANE)->GetPointer(block.GetX() - nOBMCMargin + mvx2, block.GetY() - nOBMCMargin + mvy2 );
   }
   else
   {
      int idx = (mvx & 1) + 2 * (mvy & 1);
      offx = (idx & 1) ? 1 : 0;
      offy = (idx & 2) ? 1 : 0;
      offx2 = (idx & 1) ? 1 : 0;
      offy2 = (idx & 2) ? 1 : 0;
      mvx = mvx / 2;
      mvy = mvy / 2;
      pSrc = pFrame->GetPlane(YPLANE)->GetPointer(block.GetX() * 2 - offx - nOBMCMargin * 2, block.GetY() * 2 - offy - nOBMCMargin * 2);
      pSrc2 = pFrame2->GetPlane(YPLANE)->GetPointer(block.GetX() * 2 - offx2 - nOBMCMargin * 2, block.GetY() * 2 - offy2 - nOBMCMargin * 2);
      pWeights = pBlkSadModifier[idx];
   }

   int nX = block.GetX() + mvx - nOBMCMargin;
   int nY = block.GetY() + mvy - nOBMCMargin;

   int minX = 0;
   int minY = 0;
   int maxX = nBlkSize + offx + 2 * nOBMCMargin;
   int maxY = nBlkSize + offy + 2 * nOBMCMargin;

   if ( nX < 0 ) 
      minX += -nX;
   if ( nY < 0 )
      minY += -nY;
   if ( nX + maxX > nWidth )
      maxX = nWidth - nX;
   if ( nY + maxY > nHeight )
      maxY = nHeight - nY;

   pSrc += minY * pFrame->GetPlane(YPLANE)->GetPitch();
   pSrc2 += minY * pFrame2->GetPlane(YPLANE)->GetPitch();
   pWeights += minY * ( nBlkSadPitch + offx );

   int offset = nX + nY * nExtendedPitch;

   for ( int i = minY; i < maxY; i++ )
   {
      for ( int j = minX; j < maxX; j++ )
      {
         int off = i * nExtendedPitch + j + offset;
         Pixels pix;
         pix.nBlk = (pSrc[j] * abs(nRatio) + (1024 - abs(nRatio)) * pSrc2[j] + 512) >> 10;
         pix.nSad = ((block.GetSAD() * pWeights[j]) * nSadRatio * (pSrc2[j] - pSrc[j])) >> 10;
         pix.nBlk = nBlk;
         pFinalDst[off].push_back(pix);
      }
      pSrc += pFrame->GetPlane(YPLANE)->GetPitch();
      pSrc2 += pFrame2->GetPlane(YPLANE)->GetPitch();
      pWeights += nBlkSadPitch + offx;
   }
}

const Pixels foo = { 0, -1, -1 };

void MVBidouille::CollectResults(unsigned char *pDst, int nDstPitch, int width, int height)
{
   unsigned int nMinSad;
   unsigned char bestValue;

   Pixels *pDsst = pTempFinal;

   typedef std::list<std::pair<int, int> >coordList;

   coordList list;

   int pb = 0;

   for ( int j = 0; j < height; j++ )
   {
      for ( int i = 0; i < width; i++ )
      {
         PixelsList &tlist = pFinalDst[i + j * nExtendedPitch];
         PixelsList::const_iterator best = tlist.begin();
         nMinSad = ( nBoo & 16 ) ? 3000 : 1500;
         bestValue = 255;
         for ( PixelsList::const_iterator it = tlist.begin(); it != tlist.end(); it++ )
         {
            if ( it->nSad < nMinSad )
            {
               best = it;
               nMinSad = it->nSad;
            }
         }
         if ( it != tlist.end() )
            pDsst[i] = *it;
         else
            pDsst[i] = foo;

         list.push_back(std::pair<int, int>(i, j));
      }
      pDsst += nExtendedPitch;
      for ( int i = 0; i < 10; i++ )
         pPixels[i] += nExtendedPitch;
   }

   typedef std::map<const int, int> cla;

   cla classes;

//   random_shuffle(list.begin(), list.end());

   

   while ( !list.empty() )
   {
      int lastsize = list.size();

      DebugPrintf("pb : %i\n", lastsize);
      
      for ( coordList::iterator lit = list.begin(); lit != list.end(); )
      {
         classes.clear();

         int i = lit->first;
         int j = lit->second;
         int offset = i + j * nExtendedPitch;
         Pixels *pd = pTempFinal + offset;
         for ( int k = -1; k < 2; k++ )
            for ( int l = -1; l < 2; l++ )
               if (( j+l >= 0 ) && ( j+l < height ) && ( i+k >= 0 ) && (i+k < width ))
                  classes[pd[k+l*nExtendedPitch].nBlk]++;

         cla::iterator it = std::max_element(classes.begin(), classes.end());

         if ( pd->nBlk >= 0 )
         {
            int final = 0;
            int norm = 0;
            int blk = it->first;
            while(it->second >= 1)
            {
               if (it->first >= 0 )
               {
                  if ( blk < 0 ) blk = it->first;
                  for ( int p = 0; p < pnIdx[offset]; p++ )
                     if ( pFinalDst[p][offset].nBlk == it->first )
                     {
                        int n;
                        if (pFinalDst[p][offset].nSad > 0)
                           n = 32768 / pFinalDst[p][offset].nSad;
                        else
                           n = 32768;
                           
                        final += pFinalDst[p][offset].nValue * n;
                        norm += n;
                     }
               }
               classes.erase(it);
               if ( classes.size() == 0 )
                  break;
               it = std::max_element(classes.begin(), classes.end());
            }

            //DebugPrintf("%i\n", norm);

            if ( norm == 0 )
               pTempFinal[offset].nValue = -1;
            else
            {
               pTempFinal[offset].nValue = ( final + norm / 2 ) / norm;
               pTempFinal[offset].nBlk = blk;
               lit = list.erase(lit);
               continue;
            }
         }
         
         if ( it->first == -1 )
            classes.erase(it);

         //if ( list.size() == 6 )
         //{
         //   DebugPrintf("%i %i %i %i %i", pnIdx[offset], lit->first, lit->second, pFinalDst[0][offset].nBlk, pFinalDst[1][offset].nBlk );
         //}



         while ( classes.size() )
         {
            it = std::max_element(classes.begin(), classes.end());
            for ( int p = 0; p < pnIdx[offset]; p++ )
               if ( pFinalDst[p][offset].nBlk == it->first )
               {
                  (*pd) = pFinalDst[p][offset];
                  pd->nValue = 255;
                  lit = list.erase(lit);
                  break;
               }
            if ( p < pnIdx[offset] ) break;

            classes.erase(it);
         }

         if ( classes.size() )
            continue;

         lit++;
      }
      if ( lastsize == list.size() ) break;
   }

   DebugPrintf("pb : %i\n", list.size());

   pDsst = pTempFinal;

   for ( int j = 0; j < height; j++ )
   {
      for ( int i = 0; i < width; i++ )
      {
         pDst[i] = pDsst[i].nValue;
      }
      pDst += nDstPitch;
      pDsst += nExtendedPitch;
   }


}

PVideoFrame __stdcall MVBidouille::GetFrame(int n, IScriptEnvironment* env)
{
   PVideoFrame srcprev = child->GetFrame(n, env);
   PVideoFrame srcnext = child->GetFrame(MIN(n + 1, vi.num_frames - 1), env);
   PVideoFrame dst = env->NewVideoFrame(vi);

   bwMvClip.Update(n, env);
   fwMvClip.Update(MIN(n + 1, vi.num_frames - 1), env);
   bwbwMvClip.Update(MIN(n + 1, vi.num_frames - 1), env);
   fwfwMvClip.Update(n, env);

   DebugPrintf("MVBidouille : vectors validity : %i %i\n",
      bwMvClip.GetValidity(), fwMvClip.GetValidity());

   pFrames = mvCore->GetFrames(nIdx);

   PROFILE_START(MOTION_PROFILE_INTERPOLATION);
   MVGroupOfFrames *pPrevRef = pFrames->GetFrame(n);
   pPrevRef->SetPlane(YRPLAN(srcprev), YPITCH(srcprev), YPLANE);
   pPrevRef->SetPlane(URPLAN(srcprev), UPITCH(srcprev), UPLANE);
   pPrevRef->SetPlane(VRPLAN(srcprev), VPITCH(srcprev), VPLANE);
   pPrevRef->Reduce();
   pPrevRef->Pad(YUVPLANES);
   pPrevRef->Refine(YUVPLANES);

   MVGroupOfFrames *pNextRef = pFrames->GetFrame(MIN(n + 1, vi.num_frames - 1));
   pNextRef->SetPlane(YRPLAN(srcnext), YPITCH(srcnext), YPLANE);
   pNextRef->SetPlane(URPLAN(srcnext), UPITCH(srcnext), UPLANE);
   pNextRef->SetPlane(VRPLAN(srcnext), VPITCH(srcnext), VPLANE);
   pNextRef->Reduce();
   pNextRef->Pad(YUVPLANES);
   pNextRef->Refine(YUVPLANES);
   PROFILE_STOP(MOTION_PROFILE_INTERPOLATION);

   for ( int i = 0; i < 10; i++ )
      memset(pFinalDst[i] - nOffset, 255, nExtendedPitch * nExtendedHeight * sizeof(Pixels));

   memset(pnIdx, 0, sizeof(unsigned int) * nExtendedHeight * nExtendedPitch);

   for ( int i = 0; i < nBlkCount; i++ )
   {
      if ( nBoo & 1 )
      {
         if ( bwMvClip.GetValidity() )
            MoveBlock(pPrevRef->GetFrame(0), pNextRef->GetFrame(0), bwMvClip.GetBlock(0, i), 512, 1024, i);
         if ( fwMvClip.GetValidity() )
            MoveBlock(pNextRef->GetFrame(0), pPrevRef->GetFrame(0), fwMvClip.GetBlock(0, i), 512, 1024, i);
      }
      if ( nBoo & 2 )
      {
         if ( fwfwMvClip.GetValidity() )
            MoveBlock(pPrevRef->GetFrame(0), fwfwMvClip.GetBlock(0, i), -512, 8192, i);
         if ( bwbwMvClip.GetValidity() )
            MoveBlock(pNextRef->GetFrame(0), bwbwMvClip.GetBlock(0, i), -512, 8192, i);
      }
   }

   if ( n > 0 )
      CollectResults(YWPLAN(dst), YPITCH(dst), nWidth, nHeight);

   return dst;
}
