
// Change the number of frames of the clip without changing its speed

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#ifndef __MV_BIDOUILLE__
#define __MV_BIDOUILLE__

#include "MVInterface.h"
#include <slist>

typedef struct {
   unsigned char nValue;
   unsigned int nSad;
   int nBlk;

} Pixels;

typedef std::slist<Pixels> PixelsList;

class MVBidouille : public GenericVideoFilter, public MVFilter {

	MVClip fwMvClip;
	MVClip bwMvClip;
   MVClip fwfwMvClip;
   MVClip bwbwMvClip;

   MVFrames *pFrames;

   int nOBMCMargin;

   int nExtendedWidth;
   int nExtendedHeight;
   int nExtendedPitch;

   int nOffset;
   int nOffsetUV;

   int nIdx;
   int nBoo;

   int **pBlkSadModifier;
   int nBlkSadPitch;

   PixelsList *pFinalDst;
   Pixels *pTempFinal;

protected:
   void MoveBlock(MVFrame *pFrame, const FakeBlockData& block, int nRatio, int nSadRatio, int nBlk);
   void MoveBlock(MVFrame *pFrame, MVFrame *pFrame2, const FakeBlockData& block, int nRatio, int nSadRatio, int nBlk);
   void CollectResults(unsigned char *pDst, int nDstPitch, int width, int height);

public:
	MVBidouille(PClip _child, PClip bwVectors, PClip fwVectors, int _nIdx, int boo, int nSCD1, int SCD2, bool mmx, bool isse, IScriptEnvironment* env);
	~MVBidouille();
   PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env);
};

#endif