// Create a motion blur filter

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#ifndef __MV_BLUR__
#define __MV_BLUR__

#include "MVInterpolate.h"

/*! \brief Filter which show the motion mask
 */
class MVBlur : public MVInterpolate {
private:
	PClip mvclipbw, mvclipfw;
	double position;

	FakeGroupOfPlanes *fgopCN;
	FakeGroupOfPlanes *fgopCP;

	double PosWeight(double pos) { return 1.0; }
	double SADWeight(unsigned int sad) { return 1.0; }

public:
	MVBlur(PClip _child, PClip mvsbw, PClip mvsfw, int nb, double rl, int fbw, const char *str, const MotionParameters &params, IScriptEnvironment* env);
	~MVBlur();
	PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env);
};

#endif