// Change the number of frames of the clip without changing its speed

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#include "MVConvertFPS.h"
#include "info.h"
#include <memory.h>
#include <string.h>
#include <stdio.h>

MVConvertFPS::MVConvertFPS(PClip _child, PClip mvsbw, PClip mvsfw, int nb, double rl, int fbw, int sbw, int rbw, int bvt, int num, int den, double fps, const char *str, const MotionParameters &params, IScriptEnvironment* env) :
MVInterpolate(_child, mvsbw->GetVideoInfo(), nb, rl, fbw, sbw, rbw, bvt, str, params, env), mvclipbw(mvsbw), mvclipfw(mvsfw)
{
	originalCountFrame = vi.num_frames;

	if ( fps > 0 )
	{
		double n = fps;
		int d = 1;
		while (n < 16777216 && d < 16777216) { n*=2; d*=2; }
		num = int(n+0.5);
		den = d;
	}

	else fps = (double)num / (double)den;

	CreateFGOP(&fgopCP);
	CreateFGOP(&fgopCN);
	CreateFGOP(&fgopNC);
	CreateFGOP(&fgopNoN);

	/*if (fps < (double)vi.fps_numerator / (double)vi.fps_denominator )
		env->ThrowError("You have to increase the frame per number in order this filter to work");*/

	a = __int64(vi.fps_numerator) * den;
	b = __int64(vi.fps_denominator) * num;
	vi.SetFPS(num, den);
	vi.num_frames = int((vi.num_frames * b + (a >> 1)) / a);
}

MVConvertFPS::~MVConvertFPS()
{
}

PVideoFrame __stdcall MVConvertFPS::GetFrame(int n, IScriptEnvironment* env)
{
	// currframe is the closest frame to the frame to be interpolated
	int currframe = int(((__int64)n * a + (b>>1)) / b);

	// nextframe is the second closest one
	int nextframe = int(((__int64)n * a) / b);
	if ( nextframe == currframe ) nextframe++;

	// pos is the relative position of the interpolated frame between
	// currframe and nextframe
	double position = ((double)n * (double)a / (double)b) - currframe;
	if ( position < 0 ) position = -position;

	PVideoFrame			src			 = child->GetFrame(currframe, env);
	const unsigned char	*srcp_y		 = src->GetReadPtr(PLANAR_Y);
	const int			src_pitch_y  = src->GetPitch(PLANAR_Y);
	
	PVideoFrame			der			 = env->NewVideoFrame(vi);

	// Resetting of the arrays used for building the motion blur.

	memset(compensationsy, 0, nWidth * nHeight * 4);
	memset(nbcompensationsy, 0, nWidth * nHeight * 4);
	memset(wcompensationsy, 0, nWidth * nHeight * 4);
	memset(nbwcompensationsy, 0, nWidth * nHeight * 4);
	memset(wwcompensationsy, 0, nWidth * nHeight * 4);
	memset(nbwwcompensationsy, 0, nWidth * nHeight * 4);
	memset(compensationsu, 0, nWidth * nHeight);
	memset(nbcompensationsu, 0, nWidth * nHeight);
	memset(wcompensationsu, 0, nWidth * nHeight);
	memset(nbwcompensationsu, 0, nWidth * nHeight);
	memset(wwcompensationsu, 0, nWidth * nHeight);
	memset(nbwwcompensationsu, 0, nWidth * nHeight);
	memset(compensationsv, 0, nWidth * nHeight);
	memset(nbcompensationsv, 0, nWidth * nHeight);
	memset(wcompensationsv, 0, nWidth * nHeight);
	memset(nbwcompensationsv, 0, nWidth * nHeight);
	memset(wwcompensationsv, 0, nWidth * nHeight);
	memset(nbwwcompensationsv, 0, nWidth * nHeight);

	if ( currframe > nextframe )
	{
		GetVectorStream(currframe, env, mvclipbw, fgopCP);
		GetVectorStream(currframe, env, mvclipfw, fgopCN);
		GetVectorStream(nextframe, env, mvclipbw, fgopNC);
		GetVectorStream(nextframe, env, mvclipfw, fgopNoN);
	}
	else {
		GetVectorStream(currframe, env, mvclipfw, fgopCP);
		GetVectorStream(currframe, env, mvclipbw, fgopCN);
		GetVectorStream(nextframe, env, mvclipfw, fgopNC);
		GetVectorStream(nextframe, env, mvclipbw, fgopNoN);
	}

	PVideoFrame srcnext = (( nextframe >= 0 ) && ( nextframe < originalCountFrame )) ? child->GetFrame(nextframe, env) : child->GetFrame(currframe, env);

	if ( IsUsable(fgopCP) )
	{
		for ( int j = 0; j < nHeight; j++)
			RevTreatBlock(GetBlock(fgopCP,0,j), src, position);
	}
	if ( IsUsable(fgopCN) )
	{
		for ( int j = 0; j < nHeight; j++)
			TreatBlock(GetBlock(fgopCN,0,j), src, position);
	}
	if ( IsUsable(fgopNC) )
	{
		for ( int j = 0; j < nHeight; j++)
			TreatBlock(GetBlock(fgopNC,0,j), srcnext, 1 - position);
	}
	if ( IsUsable(fgopNoN) )
	{
		for ( int j = 0; j < nHeight; j++)
			RevTreatBlock(GetBlock(fgopNoN,0,j), srcnext, 1 - position);
	}

	BuildBlurring(der, src, srcnext);

	return der;
}
