// Change the number of frames of the clip without changing its speed

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#include "MVCreateFrame.h"
#include <memory.h>
#include <string.h>
#include <stdio.h>

MVCreateFrame::MVCreateFrame(PClip _child, PClip mvsbw, PClip mvsfw, int nb, double bl, double el, int fbw, int sbw, int rbw, int bvt, const char *str, const MotionParameters &params, IScriptEnvironment* env) :
MVInterpolate(_child, mvsbw->GetVideoInfo(), nb, el - bl, fbw, sbw, rbw, bvt, str, params, env), mvclipbw(mvsbw), mvclipfw(mvsfw)
{
	position = ( el + bl ) / 2;

	CreateFGOP(&fgopCP);
	CreateFGOP(&fgopCN);
	CreateFGOP(&fgopPC);
	CreateFGOP(&fgopPoP);
}

MVCreateFrame::~MVCreateFrame()
{
}

PVideoFrame __stdcall MVCreateFrame::GetFrame(int n, IScriptEnvironment* env)
{

	PVideoFrame			src			 = child->GetFrame(n, env);
	PVideoFrame			der			 = env->NewVideoFrame(vi);

	// Resetting of the arrays used for building the motion blur.

	memset(compensationsy, 0, nWidth * nHeight * 4);
	memset(nbcompensationsy, 0, nWidth * nHeight * 4);
	memset(wcompensationsy, 0, nWidth * nHeight * 4);
	memset(nbwcompensationsy, 0, nWidth * nHeight * 4);
	memset(wwcompensationsy, 0, nWidth * nHeight * 4);
	memset(nbwwcompensationsy, 0, nWidth * nHeight * 4);
	memset(compensationsu, 0, nWidth * nHeight);
	memset(nbcompensationsu, 0, nWidth * nHeight);
	memset(wcompensationsu, 0, nWidth * nHeight);
	memset(nbwcompensationsu, 0, nWidth * nHeight);
	memset(wwcompensationsu, 0, nWidth * nHeight);
	memset(nbwwcompensationsu, 0, nWidth * nHeight);
	memset(compensationsv, 0, nWidth * nHeight);
	memset(nbcompensationsv, 0, nWidth * nHeight);
	memset(wcompensationsv, 0, nWidth * nHeight);
	memset(nbwcompensationsv, 0, nWidth * nHeight);
	memset(wwcompensationsv, 0, nWidth * nHeight);
	memset(nbwwcompensationsv, 0, nWidth * nHeight);

	GetVectorStream(n, env, mvclipbw, fgopCN);
	GetVectorStream(n, env, mvclipfw, fgopCP);
	GetVectorStream(n-1, env, mvclipbw, fgopPC);
	GetVectorStream(n-1, env, mvclipfw, fgopPoP);

	PVideoFrame srcprev = ( n > 0 ) ? child->GetFrame(n-1, env) : child->GetFrame(n, env);

	if ( IsUsable(fgopCP) )
	{
		for ( int j = 0; j < nBlkCount; j++)
			TreatBlock(GetBlock(fgopCP,0,j), src, position);
	}
	if ( IsUsable(fgopCN) )
	{
		for ( int j = 0; j < nBlkCount; j++)
			RevTreatBlock(GetBlock(fgopCN,0,j), src, position);
	}
	if ( IsUsable(fgopPC) )
	{
		for ( int j = 0; j < nBlkCount; j++)
			TreatBlock(GetBlock(fgopPC,0,j), srcprev, 1 - position);
	}
	if ( IsUsable(fgopPoP) )
	{
		for ( int j = 0; j < nBlkCount; j++)
			RevTreatBlock(GetBlock(fgopPoP,0,j), srcprev, 1 - position);
	}

	BuildBlurring(der, src, srcprev);

	return der;
}
