// Make a motion compensate temporal denoiser

// See legal notice in Copying.txt for more information

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
// http://www.gnu.org/copyleft/gpl.html .

#ifndef __MVDENOISE__
#define __MVDENOISE__

#include "GenericMotionFilter.h"


/*! \brief Filter that denoise the picture
 */
class MVDenoise : public GenericMotionFilter {
private:
	/*! \brief Temporal threshold. After the motion compensation, we check again that threshold
	 *	that the pixel has not varied to much. If it has, we discard the compensation.
	 */
	int TemporalThreshold;

	/*! \brief Last threshold. Even in non scenechange frame, there are erratic blocks.
	 *	We test the erraticness once again, again this threshold, in order to know whether
	 *	we compensate the block or not.
	 */
	int MotionCoherenceThreshold;

	int SADThreshold;

	int MVThreshold;

	int pitch;

	int size;

	int offset;

	FakeGroupOfPlanes *fgopCN;
	FakeGroupOfPlanes *fgopCP;
	FakeGroupOfPlanes *fgopPoP;
	FakeGroupOfPlanes *fgopNoN;
	PClip mvclipBW;
	PClip mvclipFW;

	unsigned char *nextFrame, *previousFrame;
	unsigned char *cFrame, *nFrame, *nnFrame, *ppFrame, *pFrame;
	unsigned char *previousMask, *nextMask;

protected:
	void DenoiseBlock(unsigned char *derp, int der_pitch);
	inline int MABS(int x) { return ( x < 0 ) ? -x : x; }

public:
	MVDenoise(PClip _child, PClip mvsbw, PClip mvsfw, int thT, int thMC, int sadT, int thMV, const MotionParameters &params, IScriptEnvironment* env);
	~MVDenoise();
	PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env);
};

#endif