#include "MVFileHandler.h"

MVFileHandler::MVFileHandler(const char *fileName, bool read)
{
	
	currentPosInBuffer = 0;
	buffer = new unsigned int[1000000];
	currentPosBitInInt = 0;
	if ( read )	file = fopen(fileName, "rb");
	else file = fopen(fileName, "wb");
	currentInt = 0;
}

MVFileHandler::~MVFileHandler()
{
	delete[] buffer;
	fclose(file);
}

bool MVFileHandler::get()
{
	if ( currentPosBitInInt == 32 )
	{
		currentPosInBuffer++;
		currentInt = buffer[currentPosInBuffer];
		currentPosBitInInt = 0;
	}
	unsigned int bitMask = ((unsigned int)1) << currentPosBitInInt;
	currentPosBitInInt++;
	return bitMask & currentInt;
}

void MVFileHandler::put(bool b)
{
	if ( currentPosBitInInt == 32 )
	{
		buffer[currentPosInBuffer] = currentInt;
		currentInt = 0;
		currentPosInBuffer++;
		currentPosBitInInt = 0;
	}

	if ( b ) currentInt |= (((unsigned int)1) << currentPosBitInInt);
	currentPosBitInInt++;
}

void MVFileHandler::loadBlock()
{
	int size;
	int frameNumber;
	fread(&size,sizeof(int),1,file);
	fread(&frameNumber,sizeof(int),1,file);
	fread(buffer,sizeof(int),size,file);

	currentPosInBuffer = 0;
	currentPosBitInInt = 0;
	if ( size > 0 )
		currentInt = buffer[0];
}

int MVFileHandler::skipBlock()
{
	int size;
	int frameNumber;
	fread(&size,sizeof(int),1,file);
	fread(&frameNumber,sizeof(int),1,file);
	int last = fread(buffer,sizeof(int),size,file);
	return ( last < size ) ? -1 : frameNumber;
}

void MVFileHandler::flushBlock(int frameNumber)
{
	if ( currentPosBitInInt > 0 )
		currentPosInBuffer++;

	fwrite(&currentPosInBuffer,sizeof(int),1,file);
	fwrite(&frameNumber,sizeof(int),1,file);
	fwrite(buffer,sizeof(int),currentPosInBuffer,file);
	currentPosInBuffer = 0;
	currentPosBitInInt = 0;
	currentInt = 0;
}

void MVFileHandler::writeInt(int x)
{
	fwrite(&x, sizeof(int), 1, file);
}

int MVFileHandler::readInt()
{
	int value;
	fread(&value, sizeof(int), 1, file);
	return value;
}

void MVFileHandler::writeShort(int x)
{
	fwrite(&x, sizeof(int), 1, file);
}

int MVFileHandler::readShort()
{
	int value;
	fread(&value, sizeof(int), 1, file);
	return value;
}

void MVFileHandler::writeByte(int x)
{
	fwrite(&x, sizeof(int), 1, file);
}

int MVFileHandler::readByte()
{
	int value;
	fread(&value, sizeof(int), 1, file);
	return value;
}