#include "MVHuffman.h"

MVHuffman::MVHuffman()
{
	count = -1;
	right = left = NULL;
}

MVHuffman::MVHuffman(MVHuffman *r, MVHuffman *l)
{
	allLeafs = NULL;
	finalCode = NULL;
	if (( r == NULL ) || ( l == NULL ))
	{
		right = left = NULL;
		count = -1;
	}
	else {
		count = l->count + r->count;
		left = l;
		right = r;
		nbSymbols = l->nbSymbols;
	}
}

MVHuffman::MVHuffman(int v, long c, int nb)
{
	allLeafs = NULL;
	finalCode = NULL;
	right = NULL;
	left = NULL;
	value = v;
	count = c;
	nbSymbols = nb;
}

MVHuffman::~MVHuffman()
{
	if ( right != NULL )
		delete right;
	if ( left != NULL )
		delete left;
	if ( allLeafs != NULL )
		delete allLeafs;
	if ( finalCode != NULL )
		delete finalCode;
}

void MVHuffman::SortArray(MVHuffman **array, MVHuffman **temp, int begin, int end)
{
	if (begin == end) return;
	if (begin + 1 == end) return;

	int half = begin + (end - begin) / 2;

	SortArray(array, temp, begin, half);
	SortArray(array, temp, half, end);

	for ( int count = begin; count < end; count++ )
		temp[count] = array[count];

	int index1 = begin;
	int index2 = half;
	for ( int count = begin; count < end; count++ )
	{
		if ( index1 == half )
		{
			array[count] = temp[index2];
			index2++;
		}
		else if ( index2 == end )
		{
			array[count] = temp[index1];
			index1++;
		}
		else if ( temp[index1]->count < temp[index2]->count )
		{
			array[count] = temp[index1];
			index1++;
		}
		else {
			array[count] = temp[index2];
			index2++;
		}
	}
}

void MVHuffman::ReSortHeap(MVHuffman **heap, int pos)
{
	if (pos == 0) return;
	int father = pos / 2;
	if ( heap[father]->count > heap[pos]->count )
	{
		MVHuffman *temp = heap[pos];
		heap[pos] = heap[father];
		heap[father] = temp;
		ReSortHeap(heap, father);
	}
}

void MVHuffman::DeleteRoot(MVHuffman **heap, MVHuffman *root, int pos, int pos_max)
{
	if ( pos >= pos_max ) return;
	heap[pos] = root;
	int rootcount = ( root == NULL ) ? 0x7FFFFFFF : root->count;
	int fg = pos * 2, fd = pos * 2 + 1;
	if ( fg >= pos_max ) return;
	if ( fd >= pos_max )
	{
		if ( heap[fg] == NULL ) return;
		if ( heap[fg]->count < rootcount )
		{
			heap[pos] = heap[fg];
			heap[fg] = root;
			return;
		}
		return ;
	}
	if (( heap[fg] == NULL ) && ( heap[fd] == NULL)) return;
	if ( heap[fd] == NULL )
	{
		if ( heap[fg]->count < rootcount )
		{
			heap[pos] = heap[fg];
			DeleteRoot(heap, root, fg, pos_max);
			return;
		}
		return;
	}
	if ( heap[fg] == NULL )
	{
		if ( heap[fd]->count < rootcount )
		{
			heap[pos] = heap[fd];
			DeleteRoot(heap, root, fd, pos_max);
			return;
		}
		return;
	}
	if ( heap[fd]->count < rootcount )
	{
		if ( heap[fd]->count < heap[fg]->count )
		{
			heap[pos] = heap[fd];
			DeleteRoot(heap, root, fd, pos_max);
			return;
		}
		else {
			heap[pos] = heap[fg];
			DeleteRoot(heap, root, fg, pos_max);
			return;
		}
	}
	if ( heap[fg]->count < rootcount )
	{
		heap[pos] = heap[fg];
		DeleteRoot(heap, root, fg, pos_max);
		return;
	}
	return;


}
//
//void MVHuffman::Print()
//{
//	printf("%i : ", value);
//	for ( int i = 0; i < codeLength; i++ )
//		if ( finalCode[i] ) printf("1");
//		else printf("0");
//}
//
//
//void MVHuffman::PrintAllLeafs()
//{
//	for ( int i = 0; i < nbSymbols; i++ )
//	{
//		allLeafs[i]->Print();
//		printf("\n");
//	}
//}
//
//void MVHuffman::PrintCode(int symbol)
//{
//	allLeafs[symbol]->Print();
//	printf("\n");
//}


MVHuffman *MVHuffman::BuildHuffmanTree(const int *array, int nbsymbols)
{
	MVHuffman **leafs = new MVHuffman*[nbsymbols];
	MVHuffman **temp = new MVHuffman*[nbsymbols];
	MVHuffman **temp2 = new MVHuffman*[nbsymbols];
	for ( int i = 0; i < nbsymbols; i++ )
	{
		leafs[i] = new MVHuffman(i, array[i], nbsymbols);
		temp2[i] = leafs[i];
	}

	SortArray(leafs, temp, 0, nbsymbols);

	MVHuffman *f1, *f2;

	for ( int i = 0; i < nbsymbols - 1; i++ )
	{
		f1 = leafs[0];
		DeleteRoot(leafs, NULL, 0, nbsymbols );
		f2 = leafs[0]; 
		DeleteRoot(leafs, new MVHuffman(f1 ,f2), 0, nbsymbols);
	}

	MVHuffman *answer = leafs[0];
	delete[] leafs;
	delete[] temp;


	answer->SetAllLeafs(temp2);

	delete[] temp2;
	answer->SetLength();
	answer->SetCodes();

	return answer;
}

double MVHuffman::Entropy()
{
	double entropy = 0;
	for ( int i = 0; i < nbSymbols; i++ )
		entropy += allLeafs[i]->codeLength * ((double)(allLeafs[i]->count) / (double)count);

	return entropy;
}

void MVHuffman::SetLength(int i)
{
	codeLength = i;
	finalCode = new bool[codeLength];
	if ( left != NULL )
		left->SetLength(i + 1);
	if ( right != NULL )
		right->SetLength(i + 1);
}

void MVHuffman::SetLength()
{
	SetLength(0);
}

void MVHuffman::SetCodes()
{
	if ( left != NULL )
	{
		for ( int i = 0; i < codeLength; i++ )
			left->finalCode[i] = finalCode[i];
		left->finalCode[codeLength] = true;
		left->SetCodes();
	}
	if ( right != NULL )
	{
		for ( int i = 0; i < codeLength; i++ )
			right->finalCode[i] = finalCode[i];
		right->finalCode[codeLength] = false;
		right->SetCodes();
	}
}


void MVHuffman::SetAllLeafs(MVHuffman **leafs)
{
	allLeafs = new MVHuffman*[nbSymbols];
	for ( int i = 0; i < nbSymbols; i++ )
		allLeafs[i] = leafs[i];
}

int MVHuffman::ReadCode(MVFileHandler *input)
{
	if ((left == NULL) || ( right == NULL )) return value;
	if ( input->get() ) return left->ReadCode(input);
	else return right->ReadCode(input);
}

int MVHuffman::WriteCode(MVFileHandler *output, int symbol)
{
//	printf(" %i ",allLeafs[symbol]->value);
	for ( int i = 0; i < allLeafs[symbol]->codeLength; i++ )
		output->put(allLeafs[symbol]->finalCode[i]);

	return allLeafs[symbol]->codeLength;
}


