#ifndef __MV_HUFFMAN__
#define __MV_HUFFMAN__

#include "MVFileHandler.h"

class MVHuffman {
	int value;
	long count;
	MVHuffman *left;
	MVHuffman *right;

	MVHuffman **allLeafs;
	int nbSymbols;
	bool *finalCode;
	int codeLength;
	
	void SetLength(int i);
	void SetCodes(bool b, int d);
	void SetAllLeafs(MVHuffman **leafs);
	void SetLength();
	void SetCodes();
	void Print();

	static void SortArray(MVHuffman **array, MVHuffman **temp, int begin, int end);
	static void ReSortHeap(MVHuffman **heap, int pos);
	static void DeleteRoot(MVHuffman **heap, MVHuffman *root, int pos, int pos_max);

	MVHuffman();
	MVHuffman(MVHuffman *r, MVHuffman *l);
	MVHuffman(int v, long c, int nb);

public:

	~MVHuffman();

	int ReadCode(MVFileHandler *input);
	int WriteCode(MVFileHandler *output, int symbol);
	int GetLengthCode(int symbol) { return allLeafs[symbol]->codeLength; }
	void PrintAllLeafs();
	void PrintCode(int symbol);
	double Entropy();

	

	static MVHuffman *BuildHuffmanTree(const int *array, int nbsymbols);
};

#endif