#ifndef __MV_INTER__
#define __MV_INTER__

#include "MVInterface.h"
#include "CopyCode.h"
#include "SimpleResize.h"

/*! \brief Filter that fetch blocks the picture
 */
class MVInter : public GenericVideoFilter, public MVFilter {
private:

   MVClip mvClipB;
   MVClip mvClipF;
   int time256;
   int mode;
   int thres;
   bool isse;
   bool mmx;

   BYTE *maskBY; // shifted (projected) images planes
   BYTE *maskBU;
   BYTE *maskBV;
   BYTE *maskFY;
   BYTE *maskFU;
   BYTE *maskFV; 

   BYTE *OccY; // full frame occlusion mask
   BYTE *OccU;
   BYTE *OccV; 

   BYTE *smallMaskF;// small forward occlusion mask
   BYTE *smallMaskB; // backward
   BYTE *smallMaskO; // both

   COPYFunction *BLITLUMA;
   COPYFunction *BLITCHROMA;

	void MakeSmallMask(BYTE *image, int imagePitch, BYTE *smallmask, int nBlkX, int nBlkY, int nBlkSize, int threshold);
	void InflateMask(BYTE *smallmask, int nBlkX, int nBlkY);
	void MultMasks(BYTE *smallmaskF, BYTE *smallmaskB, BYTE *smallmaskO,  int nBlkX, int nBlkY);
	void ResultBlock(BYTE *pDst, int dst_pitch, const BYTE * pMCB, int MCB_pitch, const BYTE * pMCF, int MCF_pitch,
		const BYTE * pRef, int ref_pitch, const BYTE * pSrc, int src_pitch, BYTE *maskB, int maskB_pitch, BYTE *maskF, int maskF_pitch,
		BYTE *pOcc, int Occ_pitch, int blksize, int time256, int mode);

//	Upsizer *upsizer;
//   Upsizer *upsizerUV;
//	unsigned char **destinations;
//	unsigned char **destinationsUV;
//	void Reorganize(unsigned char *d, int dp, BYTE **destinations, int nBlkX, int nBlkY, int nBlkSize);

	SimpleResize *upsizer;
   SimpleResize *upsizerUV;


public:
	MVInter(PClip _child, PClip _mvbw, PClip _mvfw, int _time256, int _mode, int _thres, int _nIdx,
                int nSCD1, int nSCD2, bool mmx, bool isse, IScriptEnvironment* env);
	~MVInter();
	PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env);
};

#endif