#include "MVVectorsStats.h"

MVVectorsStats::MVVectorsStats(int bs, int vm)
{
	bufferSize = bs;
	bufferFill = 0;
	valueMax = vm;
	nbSymbols = 2 * vm;
	lastValue = 0;
	lastValues = new int[bufferSize];
	stats = new int[nbSymbols];
	modifiedStats = new int[nbSymbols];
	
	for ( int i = 0; i < nbSymbols; i++ )
		stats[i] = 0;

	offsetStats = stats + vm;
	hufftree = NULL;
	BuildHuffmanTree();

}

MVVectorsStats::~MVVectorsStats()
{
	delete[] stats;
	delete[] lastValues;
	delete[] modifiedStats;
	if ( hufftree != NULL ) delete hufftree;
}

void MVVectorsStats::Add(int x)
{
	if ( bufferFill < bufferSize )
	{
		lastValues[lastValue] = x;
		lastValue++;
		offsetStats[x]++;
		bufferFill++;
	}
	else {
		if ( lastValue >= bufferSize ) lastValue = 0;
		offsetStats[lastValues[lastValue]]--;
		lastValues[lastValue] = x;
		lastValue++;
		offsetStats[x]++;
	}
}

void MVVectorsStats::BuildHuffmanTree()
{
	int sum = 0;
	for ( int i = 0; i < nbSymbols; i++ )
		sum += stats[i];

	sum = ( sum == 0 ) ? 1 : sum;

	int mul = 0x79999999 / sum;

	for ( int i = 0; i < nbSymbols; i++ )
		modifiedStats[i] = ( stats[i] == 0 ) ? 1 : stats[i] * mul;

	if ( hufftree != NULL ) delete hufftree;

	hufftree = MVHuffman::BuildHuffmanTree(modifiedStats, nbSymbols);
}

int MVVectorsStats::ReadCode(MVFileHandler *input)
{
	int symbol = hufftree->ReadCode(input) - valueMax;
	Add(symbol);
	return symbol;
}

int MVVectorsStats::WriteCode(MVFileHandler *output, int symbol)
{
	Add(symbol);
	return hufftree->WriteCode(output, symbol + valueMax);
}

int MVVectorsStats::GetLengthCode(int symbol)
{
	return hufftree->GetLengthCode(symbol + valueMax);
}
