#ifndef __MV_VECTORS_STATS__
#define __MV_VECTORS_STATS__

#include "MVHuffman.h"

class MVVectorsStats {
	int valueMax;
	int nbSymbols;
	int bufferSize;
	int bufferFill;
	int *lastValues;
	int lastValue;
	int *stats;
	int *offsetStats;

	int *modifiedStats;
	MVHuffman *hufftree;

public :

	MVVectorsStats(int bs, int vm);
	~MVVectorsStats();
	void Add(int x);
	void BuildHuffmanTree();
	int ReadCode(MVFileHandler *input);
	int WriteCode(MVFileHandler *output, int symbol);
	int GetLengthCode(int symbol);
	double GetEntropy() { return hufftree->Entropy(); }

	//void Print() { hufftree->PrintAllLeafs(); }
	//void Print(int symbol) { hufftree->PrintCode(symbol + valueMax); }
};

#endif