#include "QDeQuant.h"

QDeQuant::QDeQuant(PClip _child, int q, int lev, int dz, bool _mmx, bool _isse, IScriptEnvironment* env) :
GenericVideoFilter(_child)
{
    isse = _isse;
    mmx = _mmx;
    width = vi.width;
    height = vi.height;
    quant = q;
    deadzone = dz;
    level = lev;

    //quant = sat(quant, 0, 51);

    if ( !vi.IsYV12() )
        env->ThrowError("QDeQuant : need YV12 input");

    if (( width & 7 ) || ( height & 7 )) 
        env->ThrowError("QDeQuant :  width and height must be mod 8");
}

QDeQuant::~QDeQuant()
{
}

void QDeQuant::QDQPicture(unsigned char *dstp, const unsigned char *srcp, int dstPitch, int srcPitch,
                          int w, int h, int q, int lv, int dz)
{
    int block[16];
    for ( int j = 0; j < h; j += 4 )
    {
        for ( int i = 0; i < w; i += 4 )
        {
            FITsf(block, srcp + i, srcPitch, lv);
            QDQBlock(block, q, dz);
            IITsf(dstp + i, block, dstPitch, lv);
        }

        dstp += dstPitch * 4;
        srcp += srcPitch * 4;
    }
}


const int fmatrix[16] = {
    1,  1,  1,  1,
    2,  1, -1, -2,
    1, -1, -1,  1,
    1, -2,  2, -1
};

const int mf[18] = {
    13107, 11916, 10082, 9362, 8192, 7282,
    5243, 4660, 4194, 3647, 3355, 2893,
    8066, 7490, 6554, 5825, 5243, 4559
};

const int v[18] = {
    10, 11, 13, 14, 16, 18, 
    16, 18, 20, 23, 25, 29,
    13, 14, 16, 18, 20, 23
};

const int scan[16] = {
    0, 2, 0, 2, 
    2, 1, 2, 1,
    0, 2, 0, 2,
    2, 1, 2, 1
};

const int imatrix[16] = {
    2,  2,  2,  1,
    2,  1, -2, -2,
    2, -1, -2,  2,
    2, -2,  2, -1
};

void QDeQuant::FITsf(int *dstp, const unsigned char *srcp, int srcPitch, int lv)
{
    int block[16];
    int sum;
    for ( int j = 0; j < 4; j++ )
        for ( int i = 0; i < 4; i++ )
        {
            sum = 0;
            for ( int k = 0; k < 4; k++ )
                sum += fmatrix[j * 4 + k] * (srcp[k * srcPitch + i] - lv);
            block[j * 4 + i] = sum;
        }

    for ( int j = 0; j < 4; j++ )
        for ( int i = 0; i < 4; i++ )
        {
            sum = 0;
            for ( int k = 0; k < 4; k++ )
                sum += block[j * 4 + k] * fmatrix[i * 4 + k];
            dstp[j * 4 + i] = sum;
        }
}

void QDeQuant::IITsf(unsigned char *dstp, const int *srcp, int dstPitch, int lv)
{
    int block[16];
    int sum;
    for ( int j = 0; j < 4; j++ )
        for ( int i = 0; i < 4; i++ )
        {
            sum = 0;
            for ( int k = 0; k < 4; k++ )
                sum += (imatrix[j * 4 + k] * srcp[k * 4 + i]) >> 1;
            block[j * 4 + i] = sum;
        }
    for ( int j = 0; j < 4; j++ )
        for ( int i = 0; i < 4; i++ )
        {
            sum = 0;
            for ( int k = 0; k < 4; k++ )
                sum += (block[j * 4 + k] * imatrix[i * 4 + k]) >> 1;

            dstp[j * dstPitch + i] = (unsigned char)sat((sum + 32 + lv * 64) / 64, 0, 255);
        }
}

void QDeQuant::IITsf2(unsigned char *dstp, const int *srcp, int dstPitch, int lv)
{
}

const int aaa[16] = {
    25, 20, 25, 20,
    20, 16, 20, 16, 
    25, 20, 25, 20,
    20, 16, 20, 16
};


void QDeQuant::QDQBlock(int *dstp, int q, int f)
{
    int offset = (1 << (q / 6 + 15)) / f;
    int sign, srca;
    for ( int i = 0; i < 16; i++ )
    {
        srca = abs(dstp[i]);
        sign = (dstp[i] < 0) ? -1 : 1;
        dstp[i] = (((sign * ((srca * mf[scan[i] * 3 + (q % 6)] + offset) >> (q / 6 + 15))) * v[scan[i] * 3 + (q % 6)]) << (q / 6));
            //((dstp[i] * aaa[i]) / q) * q;
            
    }
}


PVideoFrame __stdcall QDeQuant::GetFrame(int n, IScriptEnvironment* env)
{
    PVideoFrame src = child->GetFrame(n, env);
    env->MakeWritable(&src);

    QDQPicture(src->GetWritePtr(PLANAR_Y), src->GetWritePtr(PLANAR_Y),
        src->GetPitch(PLANAR_Y), src->GetPitch(PLANAR_Y), width, height,
        quant, level, deadzone);
    QDQPicture(src->GetWritePtr(PLANAR_U), src->GetWritePtr(PLANAR_U),
        src->GetPitch(PLANAR_U), src->GetPitch(PLANAR_U), width / 2, height / 2,
        quant, level, deadzone);
    QDQPicture(src->GetWritePtr(PLANAR_V), src->GetWritePtr(PLANAR_V),
        src->GetPitch(PLANAR_V), src->GetPitch(PLANAR_V), width / 2, height / 2,
        quant, level, deadzone);

    return src;

}


